//boc ---------- (BeginOfCode)
// ■ JPEGデータを一定周期でサーバへ送信するサンプル
var display = require('display');
var video = require('video');
var jpeg = require('jpeg');
var nic = require('nic');
var http = require('http');
var AlignedBuffer = require('aligned_buffer').AlignedBuffer;
require('fixup')('http');

/************/
/* settings */
/************/
// JPEGデータ送信先サーバのネットワーク設定
var server = {
	host: "172.27.1.196",		// HTTPサーバのIPアドレス（★）
	port: 8000					// HTTPサーバのポート番号
};

// GR-PEACH のネットワーク設定
var dhcp = true;				// DHCP使用フラグ
var ifconfig = {
	ip: "172.27.1.234",			// IPアドレス
	netmask: "255.255.255.0",	// サブネットマスク
	gateway: "172.27.1.1",		// デフォルトゲートウェイ
	dns: "8.8.8.8"				// DNSサーバ
};

var interval = 1000;			// JPEGデータ送信周期(ミリ秒)
/************/

var width = 480;
var height = 272;
var video_format = 'ycbcr422';
var pixel_bytes = 2;
var alignment = 32;
var video_buf = new AlignedBuffer(width * height * pixel_bytes, alignment);

var lcd_config = {
	type : '4.3inch'
};
var camera_config = {
	width : width,
	height : height,
	format : video_format,
	type : 'ov7725'
};
var jpeg_config = {
	width : width,
	height : height,
	format : video_format
};

var eth = nic.enumerate().ETHERNET;
if( eth ) {
	if ( dhcp ) {
		eth.ifup();							// DHCP
	} else {
		eth.ifup(ifconfig);					// 静的IPアドレス指定
	}
	eth.ntpdate({ server: "ntp.nict.jp" }); // 時刻同期
}

/* LCD初期化 */
display.openLCD(lcd_config, function(err, lcd) {
	if(err) {
		console.log(err);
		process.exit();
	}

	/* カメラ初期化 */
	video.openCMOSCamera(camera_config, function(err, video_source) {
		if(err) {
			console.log(err);
			process.exit();
		}

		/* カメラ映像をLCDへ出力開始 */
		video_source.startSync(video_buf);
		lcd.startSync(0, video_buf, video_format);

		/* カメラ映像をサーバへ送信開始 */
		snapshot();
	});
});

var i = 0;
/* カメラ映像をJPEGエンコードし、サーバへ送信する */
function snapshot() {
	jpeg_config.bitmap = new AlignedBuffer(video_buf, alignment);
	jpeg.encode(jpeg_config, function(err, jpeg_data) {
		if(err) {
			console.log(err);
			process.exit();
		}
		console.log(++i, ' : jpeg_data.length', jpeg_data.length);

		/* HTTPリクエスト作成 */
 		var data = '{"image":"' + jpeg_data.toBuffer().toString('base64') + '"}';
		var options = {
			host: server.host,
			port: server.port,
			method: 'POST',
			headers: {
				'Host': server.host + ':' + server.port,
				'Content-Type': 'application/json',
				'Content-Length': data.length
			}
		};
		var req = http.request(options, function(res) {
			var body = '';
			console.log( 'res.statusCode', res.statusCode);

			res.on('data',function(chunk) {
				body += chunk;
			});
			res.on('end',function() {
				/* 送受信完了 */
				console.log(body);
				/* interval後に次の送信を開始する */
				setTimeout(snapshot, interval);
			});
			res.on( 'error', function( err ) {
				/* エラー終了 */
				console.log( err );
				process.exit();
			});
		});
		req.on( 'error', function( err ) {
			/* エラー終了 */
			console.log( err );
			process.exit();
		});

		/* リクエスト送信 */
		req.write(data);
		req.end();
	});
}
//eoc ---------- (EndOfCode)
