/* Copyright 2017-present Renesas Electronics Corporation and other contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef IOTJS_MODULE_DISPLAY_H
#define IOTJS_MODULE_DISPLAY_H

#include "iotjs_def.h"
#include "iotjs_handlewrap.h"
#include "iotjs_ext_module_periph_common.h"
#include "iotjs_reqwrap.h"

typedef struct iotjs_display_platform_data_s iotjs_display_platform_data_t;

typedef struct {
  jerry_value_t jobject;
  iotjs_display_platform_data_t* platform_data;

  lcd_t lcd;								/* display.open() */
  lcd_layer_t lcd_layer[LCDLAYER_MAX];		/* lcd.start() */
  lcd_layer_id_t layer_id[LCDLAYER_MAX];	/* lcd.stop() */
} iotjs_display_t;

bool iotjs_display_open(iotjs_display_t* display);
bool iotjs_display_start(iotjs_display_t* display);
bool iotjs_display_stop(iotjs_display_t* display);
bool iotjs_display_update(iotjs_display_t* display);
bool iotjs_display_close(iotjs_display_t* display);

void iotjs_display_create_platform_data(iotjs_display_t* display);
void iotjs_display_destroy_platform_data(iotjs_display_platform_data_t* pdata);
jerry_value_t iotjs_display_set_platform_config(iotjs_display_t* display,
                                             const jerry_value_t jconfig);

#endif /* IOTJS_MODULE_DISPLAY_H */
