/* Copyright 2017-present Renesas Electronics Corporation and other contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef IOTJS_MODULE_ALIGNED_BUFFER_H
#define IOTJS_MODULE_ALIGNED_BUFFER_H


typedef struct {
  jerry_value_t jobject;
  size_t length;
  uint32_t alignment;
  uint32_t offset;
  char buffer[];
} iotjs_aligned_buffer_wrap_t;


iotjs_aligned_buffer_wrap_t* iotjs_aligned_buffer_wrap_create(const jerry_value_t jbuiltin,
                                            size_t length, size_t alignment);

iotjs_aligned_buffer_wrap_t* iotjs_aligned_buffer_wrap_from_jbuffer(const jerry_value_t jbuffer);
char* iotjs_aligned_buffer_wrap_native_buffer_ptr(iotjs_aligned_buffer_wrap_t* bufferwrap);

// Fail-safe creation of AlignedBuffer object.
jerry_value_t iotjs_aligned_buffer_wrap_create_buffer(size_t len, size_t alignment);

size_t iotjs_aligned_buffer_wrap_copy(iotjs_aligned_buffer_wrap_t* bufferwrap, const char* src,
                             size_t len);

#endif /* IOTJS_MODULE_ALIGNED_BUFFER_H */
