/* Copyright 2017-present Renesas Electronics Corporation and other contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef IOTJS_MODULE_VIDEO_H
#define IOTJS_MODULE_VIDEO_H

#include "iotjs_def.h"
#include "iotjs_handlewrap.h"
#include "iotjs_ext_module_periph_common.h"
#include "iotjs_reqwrap.h"

typedef struct iotjs_video_platform_data_s iotjs_video_platform_data_t;

typedef struct {
  jerry_value_t jobject;
  iotjs_video_platform_data_t* platform_data;

  video_source_t video_source;
} iotjs_video_t;

bool iotjs_video_open(iotjs_video_t* video);
bool iotjs_video_start(iotjs_video_t* video);
bool iotjs_video_stop(iotjs_video_t* video);
bool iotjs_video_read_frame(iotjs_video_t* video);
bool iotjs_video_close(iotjs_video_t* video);

void iotjs_video_create_platform_data(iotjs_video_t* video);
void iotjs_video_destroy_platform_data(iotjs_video_platform_data_t* pdata);
jerry_value_t iotjs_video_set_platform_config(iotjs_video_t* video,
                                             const jerry_value_t jconfig);

#endif /* IOTJS_MODULE_VIDEO_H */
