#include "mbed.h"
#include "TextLCD.h"
#include "DS1820.h"



DigitalOut myled(LED1);  // Uporabimo led na vezju (D13)
DigitalOut rw(A6);
DS1820 ds1820(PB_4);     // Pin kamor je priključen DS1820
DigitalOut my_pwm(D9);   // IO used by pwm_io function
TextLCD lcd(A7, A5, A4, A3, A2, A1, TextLCD::LCD20x4); // rs, e, d4-d7 TextLCD::LCD20x4

Timeout timer;



int on_delay = 0;
int off_delay = 0;

void toggleOff(void);   //??

void toggleOn(void) {  // Funkcija 
    my_pwm = 1;
    timer.attach_us(toggleOff, on_delay);
}

void toggleOff(void) {
    my_pwm = 0;
    timer.attach_us(toggleOn, off_delay);
}

// p_us = signal period in micro_seconds
// dc   = signal duty-cycle (0.0 to 1.0)
void pwm_io(int p_us, float dc) {
    timer.detach();
    if ((p_us == 0) || (dc == 0)) {
        my_pwm = 0;
        return;
    }
    if (dc >= 1) {
        my_pwm = 1;
        return;
    }
    on_delay = (int)(p_us * dc);
    off_delay = p_us - on_delay;
    toggleOn();
}

int main()
{

//  double moc;
    int i;
    rw = 0;
//  moc = 25;
    int PWM_F=100;                                           //delay v us 20us=50KHz  1000=1000Hz, če je manj ne dela več LCD
    float PWM_duty=0.25;
    
    while (true) {
        for (i=0; i<11; i=i+1) {    
            if (i==10){ i=0;} 
         
        ds1820.begin();              // Inicializacia DS senzorja če ni specifičen senzor
        ds1820.startConversion();
        lcd.locate(0,0);                                             // Lokacija: 1 vrstica 1 znak na LCD-ju
        lcd.printf("Stevilka: %i", i);                               // števec
        lcd.locate(0,1);                                             // Lokacija: 2 vrstica 1 znak na LCD-ju
//      lcd.printf("Moc sevanja: %.2fW", moc);                       // Na LCD-ju prikaže vrednost moči
        lcd.printf("PWMF=%i",PWM_F);                       // Na LCD-ju izpiše vrednost spremenljivke PWM_F
        lcd.locate(0,2);
        lcd.printf("PWMDuty=%1.2f",PWM_duty);             // Na LCD-ju izpiše vrednost spremenljivke PWM_duty 3.1
        lcd.locate(0,3);
        lcd.printf("Temp: %3.1foC\r\n", ds1820.read());             // Izpiše temp
        
 
        PWM_duty=ds1820.read()/100;
        pwm_io(PWM_F, PWM_duty);                           // 20ms - 25%          
        myled = !myled;
/*
        myled = 1; // LED is ON
        wait(0.1); // 100 ms
        myled = 0; // LED is OFF
        wait(0.1); // 100ms 
*/
   }
 //           wait(0.1);  // Počakaj 1s
//            lcd.cls(); // Zbriše ekran
//            pwm_io(PWM_F, PWM_duty);                           // 20ms - 25%      
    }
}