#include "mbed.h"
#include "rtos.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "wave_player.h"

// LED Components
PwmOut led(LED1);

// SD File System Components
SDBlockDevice   sd(p5, p6, p7, p8);
FATFileSystem   fs("sd");

// Audio Components
AnalogOut       dac(p18);
PwmOut          speaker(p25);
wave_player     wav(&dac, &speaker);

Thread led_thread, audio_thread;

void led_siren() {
    const int build_time = 100;
    while (1) {
        //LED warm up effect using PWM
        for(int i=0; i<build_time; i++) {
            led = i / (float) build_time;
            ThisThread::sleep_for(1000.0*0.02);
        }
        //LED at full brightness level
        led = 1.0;
        ThisThread::sleep_for(1000.0*0.25);
        //LED cool down effect using PWM
        for(int i=build_time-1; i>0; i--) {
            led = i/ (float) build_time;
            ThisThread::sleep_for(1000.0*0.02);
        }
        //LED off
        led = 0.0;
        ThisThread::sleep_for(1000.0*1.5);
    }
}

void play_audio() {
    FILE * wav_file;
    speaker.period(1.0/1000000.0);
    while (1) {
        sd.init();
        fs.mount(&sd);
        wav_file = fopen("/sd/siren.wav", "r");
        wav.play(wav_file);
        fclose(wav_file);
        sd.deinit();
        fs.unmount();
    }
}

// main() runs in its own thread in the OS
int main()
{   
    led_thread.start(led_siren);
    audio_thread.start(play_audio);
    while (true) {
        ThisThread::sleep_for(500);
    }
}
