#include "mbed.h"

#define ID 0x00
#define SENSORNUM 2

DigitalOut led(LED1);
Serial pc(USBTX,USBRX,921600);

//cap1
DigitalOut cap1Out(A1);
InterruptIn cap1Check(A0);
InterruptIn cap1Get(A2);

//割り込み処理（参考：https://os.mbed.com/users/okini3939/notebook/ticker_jp/）
Ticker sig;

Timer t1;
Timer t2;
Timer constantTimer;//マイコン起動時間計測用タイマー
uint32_t data[SENSORNUM]= {0};

uint32_t constantTime=0;

bool outPutState=false;

void check1Out()
{
    t1.start();
}

uint32_t loop=0;
uint32_t ave=0;
uint32_t aveCount=0;
uint32_t sum=0;

void get1()
{
    t1.stop();
    cap1Out=0;
    data[0]=t1.read_us();
    
    if((data[0]<75)&&(data[0]>25)){
        //pc.printf("c\t");
        sum=sum+data[0];
        aveCount++;
    }
    
    if(((loop%10)==0)&&(aveCount!=0)) {
        ave=sum/aveCount;
        for(uint8_t i=0;i<2;i++){
            for(uint8_t i=0; i<1; i++) {
                if(ave>=100) {
                } else if(ave>=10) {
                    pc.printf("0");
                } else {
                    pc.printf("00");
                }
                pc.printf("%u",ave);
                //pc.printf("\t%d\t%d",sum,aveCount);
                pc.printf("\r\n");
            }
        }
        aveCount=0;
        sum=0;
    }else { 
    }
    t1.reset();
    loop++;
}

void outSig()
{
    //ID表示
    cap1Out=outPutState;
    outPutState=!outPutState;
    constantTime=constantTimer.read_us();
}

void timeRset()
{
    pc.getc();
    constantTimer.stop();
    constantTimer.reset();
    constantTimer.start();
}

int main()
{

    pc.printf("Hello!\r\n");
    pc.attach(timeRset, Serial::RxIrq);

    cap1Check.rise(&check1Out);
    cap1Get.rise(&get1);
    constantTimer.start();

    sig.attach_us(&outSig,500);

    led=1;
    while(1) {
    }
}
