#include "player.h"
#include"SDFileSystem.h"

SDFileSystem sd(D11, D12, D13, D9, "sd"); // the pinout on the mbed Cool
vs10xx vs1053(D11, D12, D13, D6, D7, D2, D8);//mosi,miso,sclk,xcs,xdcs,dreq,xreset
Serial pc(USBTX, USBRX);
playerStatetype  playerState;
ctrlStatetype ctrlState;
static unsigned char fileBuf[48000];
unsigned char *bufptr;
char karn;
char list[20][50];            //song list

char data ;
void Player::begin(void)
{
    
    DirHandle *dir;
    struct dirent *ptr;
		FileHandle *fp;
   
    vs1053.reset();
    dir = opendir("/sd");
    printf("\r\n**********playing list**********\r\n");
    unsigned char i = 0,j=0;
    while(((ptr = dir->readdir()) != NULL)&&(i <20))
    {
        if(strstr(ptr->d_name,".mp3")||strstr(ptr->d_name,".MP3"))
        {
							fp =sd.open(ptr->d_name, O_RDONLY);
							if(fp != NULL) 
							{
								char *byte = ptr->d_name;
                				j=0;
                				while(*byte){
                    				list[i][j++]  = *byte++;
                    				karn=i;
                }
                pc.printf("%2d . %s\r\n", i,list[i++]);
				//fp->close();
							}
        }
    }
		dir->closedir();
}

void Player::stop(void){
    playerState =PS_STOP;
    }
 
  
/*  This function plays back an audio file.  */
void Player::playFile(char *file) {
    int bytes;        // How many bytes in buffer left
    char n;
    
    playerState = PS_PLAY;
    vs1053.setFreq(24000000);     //hight speed
    
    FileHandle *fp =sd.open(file, O_RDONLY);
    
    if(fp == NULL) {
        printf("Could not open %s\r\n",file);

    }
    else
    {
        printf("Playing %s ...\r\n",file);
        
        /* Main playback loop */
        while((bytes = fp->read(fileBuf,48000)) > 0) {
        
        {
            bufptr = fileBuf;
            // actual audio data gets sent to VS10xx.
            while(bytes > 0)
            {
                n = (bytes < 32)?bytes:32; //การสื่อสารระหว่าง sd card มั้ง ถ้าตัดเล่นไม่ได้
                vs1053.writeData(bufptr,n);
                bytes -= n;
                bufptr += n;
                
            }
            
            
           /* if(pc.readable()) {
            	data = pc.getc();
            	uint8_t vol = 0xff;
            	vs1053.setVolume(vol);
            	}*/
            	
            uint8_t vol = 0x20;//set vlume
            vs1053.setVolume(vol);  //set vlume
            
            
            if(playerState != PS_PLAY)         //stop
            {
                fp->close();
                vs1053.softReset();
            }
            	
			}
		}
    }
}



