#include "mbed.h"
#include "HEPTA_EPS.h"
#include "HEPTA_CDH.h"
#include "HEPTA_SENSOR.h"
#include "HEPTA_COM.h"

Serial pc(USBTX,USBRX);
HEPTA_EPS eps(p16,p26);
HEPTA_CDH cdh(p5,p6,p7,p8,"sd");
HEPTA_SENSOR sensor(p17,
                    p28,p27,0xD0,0x18,
                    p13,p14,p25,p24);
HEPTA_COM com(p9,p10);
DigitalOut myleds[] = {LED1,LED2,LED3,LED4};;

int main()
{
    pc.baud(9600);
    float bt;
    float temper;
    const char* warning;
    char str[100];
    float gx,gy,gz,mx,my,mz;

    int quality=0,stnum=0,gps_check=0;
    char ns='A',ew='B',aunit='m';
    float time=0.0,latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;

    int flag = 0;
    int rcmd=0,cmdflag=0;
    mkdir("/sd/MissionData", 0777);
    FILE *dummy = fopen("/sd/MissionData/dummy.txt","w");
    fclose(dummy);
    while(1) {
        eps.power_saving_mode(&flag,&bt);
        sensor.temp_sense(&temper);
        wait(0.5);
        com.printf("flag = %d, bt = %.2f [V], temp = %.1f [C]\r\n",flag,bt,temper);
        com.xbee_receive(&rcmd,&cmdflag);

        if(flag == 1) {
            warning = "Low Battery\r\n";
            com.printf("%s",warning);
        } else if(temper > 35.0) {
            warning = "High Temperature\r\n";
            com.printf("%s",warning);
        } else if((flag == 1) & (temper > 35.0)) {
            warning = "Low Battery and High Temperature\r\n";
            com.printf("%s",warning);
        } else {}

        if (cmdflag == 1) {
            com.printf("Command Get = %d\r\n",rcmd);

            if (rcmd == 'a') {
                FILE *fp = fopen("/sd/MissionData/GyroMag.txt","w");
                if(fp == NULL) {
                    error("Could not open file for write\r\n");
                } else {
                    for(int i = 0; i < 10; i++) {
                        sensor.sen_gyro(&gx,&gy,&gz);
                        sensor.sen_mag(&mx,&my,&mz);
                        fprintf(fp,"Wx = %f, Wy = %f, Wz = %f, mx = %f, my = %f, mz = %f\r\n",gx,gy,gz,mx,my,mz);
                        wait(1.0);
                    }
                    fclose(fp);
                }
                FILE *fp1 = fopen("/sd/MissionData/GyroMag.txt","r");
                if(fp1 == NULL) {
                    error("Could not open file for read\r\n");
                } else {
                    for(int i = 0; i < 10; i++) {
                        fgets(str,100,fp1);
                        com.printf("%s",str);
                        wait(1.0);
                    }
                    fclose(fp1);
                }

            }
            if (rcmd == 'b') {
                FILE *fp = fopen("/sd/MissionData/Position.txt","w");
                if(fp == NULL) {
                    error("Could not open file for write\r\n");
                } else {
                    sensor.gps_setting();
                    for(int i = 0; i < 10; i++) {
                        sensor.gga_sensing(&time, &latitude, &ns, &longitude, &ew, &quality, &stnum, &hacu, &altitude, &aunit, &gps_check);
                        fprintf(fp,"time: %f, lat: %f,%c, long: %f,%c, altitude:%f\r\n",time,latitude,ns,longitude,ew,altitude);
                        wait(1.0);
                    }
                    fclose(fp);
                }

                FILE *fp1 = fopen("/sd/MissionData/Position.txt","r");
                if(fp1 == NULL) {
                    error("Could not open file for read\r\n");
                } else {
                    for(int i = 0; i < 10; i++) {
                        fgets(str,100,fp1);
                        com.printf("%s",str);
                        wait(1.0);
                    }
                    fclose(fp1);
                }
            }//b

            if (rcmd == 'c') {
                sensor.Sync();
                sensor.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution320x240);
                sensor.test_jpeg_snapshot_picture("/sd/MissionData/picture.jpg");

            }//c
            com.initialize();
        }
    }
}