#include "mbed.h"
#include "HEPTA_EPS.h"
#include "HEPTA_CDH.h"
#include "HEPTA_SENSOR.h"
#include "HEPTA_COM.h"

Serial pc(USBTX,USBRX);
HEPTA_EPS eps(p16,p26);
HEPTA_CDH cdh(p5,p6,p7,p8,"sd");
HEPTA_SENSOR sensor(p17,
                    p28,p27,0xD0,0x18,
                    p13,p14,p25,p24);
HEPTA_COM com(p9,p10);

int main()
{
    int rcmd=0,cmdflag=0;
    while(1) {
        wait(1.0);
        com.xbee_receive(&rcmd,&cmdflag);
        pc.printf("rcmd=%d, cmdflag=%d\r\n",rcmd, cmdflag);
        if (cmdflag == 1) {
            pc.printf("Command Get %d\r\n",rcmd);
            if(rcmd == 'h') {
                sensor.gps_setting();
                char gx[4],gy[4],gz[4],ax[4],ay[4],az[4],mx[4],my[4],mz[4],lad[8],log[8],height[4],bt[4],temper[4];
                float gx1,gy1,gz1;
                for(int i = 0; i < 1000000; i++) {
                    sensor.sen_gyro_u16(gx,gy,gz);
                    sensor.sen_gyro(&gx1,&gy1,&gz1);
                    sensor.sen_acc_u16(ax,ay,az);
                    sensor.sen_mag_u16(mx,my,mz);
                    eps.vol_u16(bt);
                    sensor.temp_sense_u16(temper);
                    sensor.lat_log_sensing_u16(lad,log,height);
                    com.putc('H');
                    pc.printf("gx=%f,gx16=%c%c%c%c\r\n",gx1,gx[0],gx[1],gx[2],gx[3]);
                    com.xbee_transmit(gx,gy,gz,ax,ay,az,mx,my,mz,lad,log,height,bt,temper);

                }
            }
            com.initialize();
        }
    }
}