#include "mbed.h"
#include "HEPTA_EPS.h"
#include "HEPTA_CDH.h"
#include "HEPTA_SENSOR.h"
#include "HEPTA_COM.h"

Serial pc(USBTX,USBRX);
HEPTA_EPS eps(p16,p26);
HEPTA_CDH cdh(p5,p6,p7,p8,"sd");
HEPTA_SENSOR sensor(p17,
                    p28,p27,0xD0,0x18,
                    p13,p14,p25,p24);
HEPTA_COM com(p9,p10);

int main()
{
    FILE *dummy = fopen("/sd/dummy.txt","w");
    fclose(dummy);
    pc.printf("Camera Snapshot Mode\r\n");
    pc.printf("Hit Any Key To Take Picture\r\n");
    while(!pc.readable()) {}
    sensor.Sync();
    sensor.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution320x240);
    sensor.test_jpeg_snapshot_data("/sd/test.txt");
    FILE *fp = fopen("/sd/test.txt", "r");
    if(fp == NULL) {
        pc.printf("Could not open file for write\r\n");
    } else {
        char str[1024];
        while((fgets(str,256,fp))!=NULL) {
            pc.printf("%s",str);
            //com.printf("%s",str);
            wait(0.001);
        }
        fclose(fp);
    }
}