#ifndef MOTION_H_
#define MOTION_H_

#include <cstdlib>
#include <mbed.h>
#include "EncoderCounter.h"
#include "Controller.h"
#include "IRSensor.h"


class Motion {
    
    public:
    
        Motion(Controller& controller, EncoderCounter& counterLeft,
                EncoderCounter& counterRight, IRSensor& irSensorL,
                IRSensor& irSensorC, IRSensor& irSensorR, 
                DigitalOut& enableMotorDriver);
        
        virtual ~Motion();
        void    move();
        void    rotateL();
        void    rotateR();
        void    stop();
        void    rotate180();
        void    test();

    private:
    
        static const float SPEEDLEFT;
        static const float SPEEDRIGHT;
        
        Controller& controller;
        EncoderCounter& counterLeft;
        EncoderCounter& counterRight;
        IRSensor& irSensorL;
        IRSensor& irSensorC;
        IRSensor& irSensorR;
        DigitalOut& enableMotorDriver;
        float distanceL;
        float distanceC;
        float distanceR;
        short countsL;
        short countsR;
        short countsLOld;
        short countsROld;
    
    };
    
#endif /* MOTION_H_ */