// DHCPClient.h 2013/4/10
#ifndef DHCPCLIENT_H
#define DHCPCLIENT_H
#include "eth_arch.h"
#include "UDPSocket.h"

#define DHCP_OFFSET_OP 0
#define DHCP_OFFSET_XID 4
#define DHCP_OFFSET_YIADDR 16
#define DHCP_OFFSET_SIADDR 20
#define DHCP_OFFSET_OPTIONS 240
#define DHCP_MAX_PACKET_SIZE 600

#define DHCP_SERVER_PORT 67
#define DHCP_CLIENT_PORT 68

// DHCP Message Type
#define DHCPDISCOVER 1
#define DHCPOFFER    2
#define DHCPREQUEST  3
#define DHCPDECLINE  4
#define DHCPACK      5
#define DHCPNAK      6
#define DHCPRELEASE  7
#define DHCPINFORM   8
#define DHCP_MAGIC_COOKIE	0x63825363
#define OPT_PAD				0
#define OPT_SUBNET_MASK			1
#define OPT_TIME_OFFSET			2
#define OPT_ROUTER			3
#define OPT_TIME_SERVER			4
#define OPT_IEN116_NAME_SERVER		5
#define OPT_DNS				6
#define OPT_LOG_SERVER			7
#define OPT_COOKIE_SERVER		8
#define OPT_LPR_SERVER			9
#define OPT_IMPRESS_SERVER		10
#define OPT_RESOURCE_LOC_SERVER		11
#define OPT_HOSTNAME			12
#define OPT_BOOTFILE_SIZE		13
#define OPT_MERIT_DUMP			14
#define OPT_DOMAIN_NAME			15
#define OPT_SWAP_SERVER			16
#define OPT_ROOT_PATH			17
#define OPT_EXTENSIONS_PATH		18
#define OPT_IP_FORWARDING		19
#define OPT_NONLOCAL_SOURCE_ROUTING	20
#define OPT_POLICY_FILTER		21
#define OPT_MAX_DATAGRAM_REASS	22
#define OPT_DEFAULT_IP_TTL		23
#define OPT_PATH_MTU_AGING_TIMEOUT	24
#define OPT_PATH_MTU_PLATEAU_TABLE	25
#define OPT_INTERFACE_MTU		26
#define OPT_ALL_SUBNETS_ARE_LOCAL	27
#define OPT_BROADCAST_ADDR		28
#define OPT_STATIC_ROUTE		33
#define OPT_VENDOR			43
#define OPT_NETBIOS_NAME_SERVER	44
#define OPT_NETBIOS_DATA_DIST	45
#define OPT_NETBIOS_NODE_TYPE	46
#define OPT_NETBIOS_SCOPE		47
#define OPT_IP_ADDR_REQ			50
#define OPT_ADDR_LEASE_TIME		51
#define OPT_DHCP_MESSAGE		53
#define OPT_SERVER_IDENT		54
#define OPT_PARAMETER_REQ		55
#define OPT_RENEWAL_TIME		58
#define OPT_REBINDING_TIME		59
#define OPT_CLIENT_IDENT		61
#define OPT_TFTP_SERVER_NAME		66
#define OPT_BOOTFILE_NAME		67
#define OPT_LDAP_URL			95	/* from draft RFC */
#define OPT_DOMAIN_SEARCH		119	/* from draft RFC 3397 */

/* site specific options */
#define SITE_HD				252
#define SITE_BF				253
#define SITE_SA				254
#define OPT_END				255

class DHCPClient {
public:
    DHCPClient();
    ~DHCPClient();
    int setup(int timeout_ms = 15*1000);
    uint8_t chaddr[6]; // MAC
    uint8_t yiaddr[4]; // IP
    uint8_t siaddr[4]; // DHCP server
    uint8_t dnsaddr[4]; // DNS
    uint8_t gateway[4];
    uint8_t netmask[4];
    uint8_t timesrv[4];
    uint8_t leaseTime[4];
    char *domainName;
   
private:
    int discover();
    int request();
    int offer(uint8_t buf[], int size);
    void add_buf(uint8_t* buf, int len);
    void fill_buf(int len, uint8_t data = 0x00);
    void add_buf(uint8_t c);
    void add_option(uint8_t code, uint8_t* buf = NULL, int len = 0);
    bool verify(uint8_t buf[], int len);
    void callback();
    UDPSocket* m_udp;
    Endpoint m_server;
    uint8_t xid[4];
    bool exit_flag;
    Timer m_interval;
    int m_retry;
    uint8_t m_buf[DHCP_MAX_PACKET_SIZE];
    int m_pos;
    WIZnet_Chip* eth;
};
#endif //DHCPCLIENT_H

