#include "mbed.h"

DigitalOut myled(LED1);
InterruptIn event(USER_BUTTON);

Serial ser(USBTX, USBRX);

bool pressed = false;

void KeyPressed()
{
    ser.printf("Key Pressed\r\n");
    pressed = true;
}

int main() {
    ser.baud(230400);
    ser.printf("Hello, World\r\n");
    event.fall(&KeyPressed);

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(1.0);
        if (pressed) {
            deepsleep();
            pressed = false;
        }
    }
}
