#include "mbed.h"

#ifdef TARGET_NUCLEO_F103RB
#define MY_LED      PC_13
#define MY_BUTTON   NC
#else
#define MY_LED      LED1
#define MY_BUTTON   USER_BUTTON
#endif

DigitalOut myled(MY_LED);


volatile int updatedLED = 0;


void ButtonPressed(void) {
     myled = !myled;
     updatedLED++;
}

int main()
{
    Serial ser(USBTX, USBRX);
    ser.baud(230400);   

    InterruptIn *event = NULL;
    if (MY_BUTTON != NC) {
        event = new InterruptIn(MY_BUTTON);
        event->fall(&ButtonPressed);
        // event.mode(PullUp);
    }

    int intrnos = 0;
   
    ser.printf("Hello, World\r\n");
    ser.printf("SysClock: %u Hz.\r\n", SystemCoreClock);

    int i = 0;
    
    for(;;) {
        while(i < 5) {
            myled = 1; // LED is ON
            wait(0.2); // 200 ms
            myled = 0; // LED is OFF
            wait(1.0); // 1 sec
            i++;
        }
        sleep();
        ser.printf("Wakeup: %d Intr: %d\r\n", ++intrnos, updatedLED);
        myled = !myled;
        wait(0.1);
   }
}
