#include "mbed.h"

DigitalOut myled(LED1);
InterruptIn event(USER_BUTTON);

event_callback_t spiCb;

#if DEVICE_SPI_ASYNCH
#define SPI_S(obj)    (( struct spi_s *)(&(obj->spi)))
#else
#define SPI_S(obj)    (( struct spi_s *)(obj))
#endif

bool pressed = false;
bool transferDone = false;

void KeyPressed()
{
    pressed = true;
}

void SPIDone(int events)
{
    transferDone = true;
}

int main() {
    event.fall(&KeyPressed);
    
    spiCb.attach(SPIDone);
    
    while(1) {
        myled = 1; // LED is ON
        wait(0.2); // 200 ms
        myled = 0; // LED is OFF
        wait(1.0); // 1 sec
        if (pressed) {
            myled = 1;
            SPI *s = new SPI(PB_5, PB_4, PB_3);
            s->frequency(100000);
            
            struct spi_s *spiobj = SPI_S(((spi_t *)( (char *)s+4) ));
            SPI_HandleTypeDef *handle = &(spiobj->handle);
            
            
            for(int i = 0; i < 400000000; i++) {
                uint8_t send[] = { 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00 };
                uint8_t rcv[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
                //s->write(0xff);
                HAL_SPI_Transmit(handle, send, 10, 10);
                //HAL_SPI_Receive(handle, rcv, 10, 10);
                
            }
            //s->transfer((uint8_t*)"aaa", 3, (uint8_t*)NULL, 0, spiCb, SPI_EVENT_COMPLETE);
            // s->transfer((uint8_t*)"aaa", 3, (uint8_t*)NULL, 0, spiCb);
            delete s;
            deepsleep();
            pressed = false;
        }
    }
}