#include "mbed.h"
#include "RF12B.h"
#include <queue>
#include <math.h>

Serial pc(USBTX, USBRX);
RF12B radiolink(p5, p6, p7, p8, p9);
AnalogIn joy_in(p17);
DigitalIn estop(p21);

//This program just listens to pc serial and sends a "sizeofpacket" prefixed packet over rf
//for now, it is as blocking as it gets..
int main() {
    while (1) {
        unsigned char stuff = (unsigned char)min(((joy_in-0.5)*128), 64.0);
        //pc.printf("%d\r\n", stuff);
        queue<char> qtobesent;
        qtobesent.push(0);
        qtobesent.push(0);
        qtobesent.push(stuff);
        qtobesent.push(0);
        if(estop.read()) {
            qtobesent.push(0);
        } else {
            qtobesent.push(1);
            }
     /*   char packet_length = pc.getc();
        for (int i = 0; i < packet_length; i++) {
            qtobesent.push(pc.getc());
        }*/
        
        radiolink.write(qtobesent);
        wait(0.1);
    }
}
