#ifndef SCANNER_H
#define SCANNER_H
#include "mbed.h"
#include "LongRangeSensor.h"
#include "VL6180x.h"
#include "StepperDrive.h"

class Scanner
{
public:
    Scanner(Serial &pc1, StepperDrive &_drive, PinName _servoL, PinName _servoR,
        VL6180x &_shortRangeL, VL6180x &_shortRangeR, 
        LongRangeSensor &_longRangeL, LongRangeSensor &_longRangeR,
        float _period = 0.2);
    void huntMode();
    void hunt();
    void avoidMode();
    void localize();
    void localizeRight();
    void localizeLeft();
    float getDistLeft() {return distLeft;}
    float getDistRight() {return distRight;}
    float getDistForwardL() {return distForwardL;}
    float getDistForwardR() {return distForwardR;}

private:
    static const int MIN_DUTY = 0;
    static const int MAX_DUTY = 6;
    static const int HALF_DUTY = 3;
    static const float DELTA_DUTY = 4.2e-3;
    float DUTY[13]; // {0.0500, 0.0542, 0.0583, 0.0625, 0.0667, 0.0708,
                    // 0.0750, 0.0792, 0.0833, 0.0875, 0.0917, 0.0958,
                    // 0.1000};
    bool pitEnable;
    int invertL;
    int invertR;
    int dutyL;
    int dutyR;
    float distLeft;
    float distRight;
    float distForwardL;
    float distForwardR;
    Serial &pc;
    StepperDrive &drive;
    PwmOut servoL;
    PwmOut servoR;
    VL6180x &shortRangeL;
    VL6180x &shortRangeR;
    LongRangeSensor &longRangeL;
    LongRangeSensor &longRangeR;
    float period;
    bool obstacle;
    bool huntFlag;
    bool avoidFlag; 
    bool objectFound;

    Ticker scanPit; // periodic interrupt timer

    void scan();

};

#endif // SCANNER_H
