#ifndef _STEPPER_DRIVE_
#define _STEPPER_DRIVE_

#include "mbed.h"

#define Ustep   16  //microstepping setup: 1, 2, 4, 8, or 16

class StepperDrive{
    public:
    StepperDrive(Serial &pc1, PinName in1, PinName in2, bool in3, PinName in4, PinName in5, bool in6, float in7, float in8, float in9 = 1000);
              //(serisl &, stepPinLeft, dirPinLeft, invertLeft, stepPinRight, dirPinRight, invertRight, wheelCircum, wheelSepar, periodUs)
    int move(float distance, float angle);
    bool isMoveDone();
    void pauseMove();
    void resumeMove();

    Serial &pc;
    int getRightSteps() { return rightSteps; }
    int getLeftSteps() { return leftSteps; }

    private:
    Ticker pit;           //periodic interrupt timer

    void pitCallback();

    void stepRight(bool dir);
    void stepLeft(bool dir);

    DigitalOut leftStep;
    DigitalOut leftDir;
    DigitalOut rightStep;
    DigitalOut rightDir;

    float wheelCircum;     //wheel circumference
    float wheelSepar;      //distance between wheels
    bool invertLeft;       //software wheel direction inversion
    bool invertRight;      //software wheel direction inversion
    bool moveComplete;

    int leftSteps;
    int rightSteps;
    float leftStepsPC;
    float rightStepsPC;
    float leftError;
    float rightError;
    int leftStepsPause; // for holding steps left during pause
    int rightStepsPause; // for holding steps right during pause
};

#endif