#ifndef __BLE_TOF_SERVICE_H__
#define __BLE_TOF_SERVICE_H__

#include "ble/BLE.h"

class TOFService {
    public:
        const static uint16_t   TOF_CHAR_ARRAY_SIZE                   =    100;
        const static uint16_t   CUSTOM_TOF_SERVICE_UUID               = 0xA000;
        const static uint16_t   TOF_CHAR_WRITE_CHARACTERISTIC_UUID    = 0xA001;
        
        TOFService(BLE& _ble) :
            ble(_ble),
            writeCharArrayCharacteristic(TOF_CHAR_WRITE_CHARACTERISTIC_UUID, writeBuffer)
        {
            static bool serviceAdded = false;
            if (serviceAdded) {
                return;
            }
    
            GattCharacteristic *charTable[] = {&writeCharArrayCharacteristic};
    
            GattService TOFService(CUSTOM_TOF_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
    
            ble.gattServer().addService(TOFService);
            serviceAdded = true;
        }
        
        GattAttribute::Handle_t getValueHandle() const {
            return writeCharArrayCharacteristic.getValueHandle();
        }
        
    private:
        BLE& ble;
    
        uint8_t writeBuffer[TOF_CHAR_ARRAY_SIZE];
    
        WriteOnlyArrayGattCharacteristic<uint8_t, sizeof(writeBuffer)> writeCharArrayCharacteristic;
};

#endif /* #ifndef __BLE_TOF_SERVICE_H__*/