#include "mbed.h"
#include "rtos.h"

DigitalOut myled[5] = {(LED1), (LED2), (LED3), (LED4), (p21)};
Thread *thread_led[4];
const int LATENCY = 400;

void start_blink(void const *argument) {
    int i = *(int*)argument;
    while (1) {
        myled[i] = !myled[i];        
                
        if (i == 3 && myled[3] == 1){
            myled[4] = myled[2] && myled[1] && myled[0];
        }
        
        thread_led[i]->wait(pow (2.0,(3-i)) * LATENCY);
    }
} 

int main() {
    int arr[4] = {0,1,2,3};
    for (int i = 0; i<4; i++) {
        myled[i] = 1;
        thread_led[i] = new Thread(start_blink, &arr[i]);
    }   
}
