
#include "mbed.h"
#include "door.h"
#include "elevator.h"
#include "hcsr04.h"
#include "DebouncedIn.h"

#define LEVEL_1 46
#define LEVEL_2 26
#define LEVEL_3 6
#define ID_DOORS 1
#define ID_ELEVATOR 2

Door door_1(PTD2);
Door door_2(PTD0);
Door door_3(PTD5);

Elevator elevator1(PTA12, PTD4, PTA4);

HCSR04 sensor(PTD3, PTD1);

DigitalIn floor1(PTB2);
DigitalIn floor2up(PTB3);
DigitalIn floor2down(PTC2);
DigitalIn floor3(PTC1);
DigitalIn floor1int(PTB1);
DigitalIn floor2int(PTB0);
DigitalIn floor3int(PTA5);
DigitalIn stop(PTC8);
DigitalIn open_door(PTA13);
DigitalIn close_door(PTC9);


Serial pc(PTA2, PTA1);

int level_ = LEVEL_1;
int pos_sensor = 0, flag = 0;


int main()
{
    while(true) 
    {   
               
        if((floor3 == 0) || (floor3int == 0))
        {
             pc.printf("3");
             level_ = LEVEL_3;                  
             wait(2);
        }
        if(floor2int == 0)
        {
           pc.printf("2");
           level_ = LEVEL_2;
           wait(2);
        }
        if((floor1 == 0) || (floor1int == 0))
        {
           pc.printf("1");
           level_ = LEVEL_1;
           wait(2);
        }
        if(stop == 0)
        {
            pc.printf("e");
        }
        if(open_door == 0)
                {
                    switch(level_)
                    {
                        case LEVEL_1:
                            door_1.open();
                        break;
                        case LEVEL_2:
                            door_2.open();
                        break;
                        case LEVEL_3:
                            door_3.open();
                        break;
                    }
                    wait(2);
                }
                 
        if(close_door == 0)
                {
                    switch(level_)
                    {
                        case LEVEL_1:
                            door_1.close();
                        break;
                        case LEVEL_2:
                            door_2.close();
                        break;
                        case LEVEL_3:
                            door_3.close();
                        break;
                    }
                    wait(2);
                }
        while(floor2down == 0)
        {
           pc.printf("d");
           elevator1.go_down();
           flag = 1;
        }
        while(floor2up == 0)
        {
           pc.printf("u");
           elevator1.go_up();
           flag = 1;
        }
        if(flag == 1)
        {
        elevator1.off();
        pc.printf("p");
        flag = 0;
        }
    }
}