#include "elevator.h"   
#include "mbed.h"

Elevator::Elevator(PinName enable_, PinName up_, PinName down_): enable(enable_), up(up_), down(down_){
        enable = 0;
}

void Elevator::go_up() {
       enable.period_ms(50);
       enable.pulsewidth_us(3500);
       Thread::wait(1);
       up = 1;
       down = 0;     
}
 
void Elevator::go_down() {
       enable.period_ms(50);
       enable.pulsewidth_us(400);
       Thread::wait(1);
       up = 0;
       down = 1;
}

void Elevator::off() {
       up = 0;
       down = 0;
}

