/*
MQTTClient.cpp
Based on MQTTClient from http://ceit.uq.edu.au/content/mqttclient-mbed-version-20
A simple MQTT client for mbed, version 2.0
By Yilun FAN, @CEIT, @JAN 2011

Bug fixes and additions by Andrew Lindsay (andrew [at] thiseldo [dot] co [dot] uk)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef MQTT_CLIENT_H
#define MQTT_CLIENT_H

#include "mbed.h"
#include "TCPSocket.h"

#define MQTTCONNECT 1<<4
#define MQTTCONNACK 2<<4
#define MQTTPUBLISH 3<<4
#define MQTTSUBSCRIBE 8<<4

#define MAX_PACKET_SIZE 128
#define KEEPALIVE 15000

/** MQTTClient 
 * 
 * Based on MQTTClient code from http://ceit.uq.edu.au/content/mqttclient-mbed-version-20
 * A simple MQTT client for mbed, version 2.0
 * By Yilun FAN, @CEIT, @JAN 2011
 *
 * Bug fixes and additions by Andrew Lindsay (andrew [at] thiseldo [dot] co [dot] uk)
 */
class MQTTClient 
{
public:

    MQTTClient();
    ~MQTTClient();
    MQTTClient(IpAddr server, int port, void (*callback)(char*, char*));
    void init(IpAddr *server, int port, void (*callback)(char*, char*));
    void init(IpAddr *server, int port, char *userName, char *password, void (*callback)(char*, char*));
    int connect(char *);
    void disconnect();
    int publish(char *, char *);
    int subscribe(char *);
    void live();
    
private:
    int open_session(char* id);
    void read_open_session();
    int send_data(const char* msg, int size);
    void read_data();
    
    char* clientId;
    char* userName;
    char *password;
    Timer timer;
    IpAddr serverIp;
    int port;
    bool connected;
    bool sessionOpened;
    
    void onTCPSocketEvent(TCPSocketEvent e);
    TCPSocket* pTCPSocket;
    Host host;
    
    int lastActivity;
    void (*callback_server)(char*, char*);
};

#endif
