#include "mbed.h"
#include "rtos.h"

#define SW1 PTC13
#define SW2 PTC17

DigitalOut led1(LED1);
AnalogIn  pot1(PTB3);
AnalogIn  pot2(PTB2);
DigitalIn btn1(SW1);
DigitalIn btn2(SW2);

DigitalOut cam_SI(PTD7);
AnalogIn cam_AO(PTD5);
DigitalOut cam_clock(PTE1);

Serial pc(USBTX, USBRX); // tx, rx

void led_thread(void const *argument)
{
    while (true) {
        led1 = !led1;
        Thread::wait(100);
    }
}

int main()
{
    uint32_t btpressed =0, i;
    float pixels[128];
    Thread * thread = new Thread(led_thread);
    
    pc.printf("Hello World\r\n");
    
    
    while (true) {
        cam_SI = 0;
        cam_clock = 1;
        
        Thread::wait(1000);
        
        if(btn1)
            btpressed++;
        if(btn2)
        {
            pc.printf("cam\r\n");
            cam_SI = 1;
            Thread::wait(1);
            cam_SI = 0;
        }
        
        for(i=0; i<128; i++)
        {
            cam_clock = 0;
            pixels[i] = cam_AO.read();
            cam_clock = 1;
        }
        
        for(i=0; i<128; i++)
            pc.printf("%f\r\n",pixels[i]);
            
        pc.printf("\r\n POT1 %f POT2 %f BTCOUNT %d\r\n\n", pot1.read(),pot2.read(), btpressed);
    }
}
