/*
* Servo motor program for OBON  by Tomoki Hokida
*
* Use RTOS in this program
*
* RTOSをバリバリ使用しているのであしあらず
* サーボを４つ使うことになったらSERVO_4をdefineしましょう
*/

#include "mbed.h"
#include "Servo.h"
#include "rtos.h"

#define DEFAULT_R 50
#define DEFAULT_L 50
#define DEFAULT_U 50
#define DEFAULT_D 50

#define SERVO_4

DigitalOut led1(LED1);
DigitalOut led2(LED2);

#ifdef SERVO_4
DigitalOut led3(LED3);
DigitalOut led4(LED4);
#endif

DigitalIn  sw[4] = {p17, p19, p18, p20};

//DigitalIn swU(p17);
//DigitalIn swD(p18);
//DigitalIn swR(p19);
//DigitalIn swL(p20);
//Servo obonU(p21);
//Servo obonR(p22);
//Servo obonD(p23);
//Servo obonL(p24);


#ifdef SERVO_4

Servo obon[4] = { p21, p22, p23, p24};

#else

Servo obon[2] = {p21,p22};

#endif

void obonThreadR(void const *argument){

    for(int j=DEFAULT_R;;){

        obon[1] = j/100.0;
        
         if((!sw[1])&&(j<100.0)){j++;}
         if((!sw[3])&&(j>0)){j--;}
         
         led1 = !led1;
         
        Thread::wait(10);
    }
}

void obonThreadU(void const *argument){
    for(int k=DEFAULT_U; ;){
        
        obon[0] = k/100.0;
        
        if((!sw[0])&&(k<100.0)){k++;}
        if((!sw[2])&&(k>0)){k--;}
        
        led2 = !led2;
        
        Thread::wait(10);
    }
}

#ifdef SERVO_4

void obonThreadL(void const *argument){
    for(int i=DEFAULT_L;;){
        
        obon[3] = i/100.0;
        
        if((!sw[3])&&(i<100.0)){i++;}
        if((!sw[1])&&(i>0)){i--;}
        
        led3 = !led3;
        
        Thread::wait(10);
    }
}

void obonThreadD(void const *argument){
    for(int l=DEFAULT_D;;){
        
        obon[2] = l/100.0;
        
        if((!sw[2])&&(l<=100.0)){l++;}
        if((!sw[1])&&(l>=0)){l--;}
        
        led4 = !led4;
        
        Thread::wait(10);
    }
}
#endif

int main() {
    
    sw[0].mode(PullUp);
    sw[1].mode(PullUp);
    sw[2].mode(PullUp);
    sw[3].mode(PullUp);
 
    
    Thread thread1(obonThreadU);
    Thread thread2(obonThreadR);
    
#ifdef SERVO_4
        
    Thread thread3(obonThreadD);
    Thread thread4(obonThreadL);

#endif
    for(;;);

}