/*
##############################################
##    Program Created by Harshavardan61     ##
##############################################
        ---- harshavardan61@gmail.com -----
        
Interfacing Bipolar stepper motor with L293D and mbed board

Connect the pins 2,7,10,15 (IN1, IN2, IN3, IN4) of L293D to the ports 9,10,11,12 of the mbed board.
Connect the pins 4, 5, 12, 13 to ground.
Connect the enable pins 1,9 (EN1,EN2) to a 5V supply(or) port 39 of mbed board .
Connect the pin 16 to +5V. It is the power supply of the chip.
Connect the pins 3, 6, 11, 14 to the four pins of the bipolar motor.
Connect the pin 8 to +12V/+9V.It is power supply for motor.
*/

#include "mbed.h"
#include "stepperMotor.h"


Serial pc(USBTX, USBRX);
sMotor motor(p9, p10, p11, p12); // creates new stepper motor: IN1, IN2, IN3, IN4


int step_speed = 600 ; // set default motor speed
int numstep = 512 ; // defines full turn of 360 degree
//you might want to calibrate this value according to your motor


int main() 
{
    //Credits
    printf("Bipolar Stepper Motor\r\n");
    printf("developed by Harshavardan61\r\n");
    printf("\n\r");
     while (1) 
     {
       motor.step(numstep,0,step_speed); //clockwise rotation for 360 degree
        wait(2);
       motor.step(numstep,1,step_speed); //anti clockwise rotation for 360 degree
        wait(2);
       motor.step(numstep/2,0,step_speed); //clockwise rotation for 180 degree
        wait(2);
       motor.step(numstep/2,1,step_speed); //anti clockwise rotation for 180 degree
        wait(2);
       motor.step(numstep/4,0,step_speed); //clockwise rotation for 90 degree
        wait(2);
       motor.step(numstep/4,1,step_speed); //anti clockwise rotation for 90 degree
     }
}