
//Connect as follows:

//----------------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open
//RFID MISO=pin4   ->   Nucleo SPI_MISO=PA_6=D12
//RFID MOSI=pin3   ->   Nucleo SPI_MOSI=PA_7=D11
//RFID SCK=pin2    ->   Nucleo SPI_SCK =PA_5=D13
//RFID SDA=pin1    ->   Nucleo SPI_CS  =PB_6=D10
//RFID RST=pin7    ->   Nucleo         =PA_9=D8
                          

#include "mbed.h"
#include "MFRC522.h"
#include "SPI.h"
#define ECHO_SERVER_PORT   7
 
 
#define SPI_MOSI D11
#define SPI_MISO D12
#define SPI_SCK D13
#define SPI_CS D10
#define MF_RESET D8


//Serial connection to PC for output
Serial pc(USBTX, USBRX);
// Serial connection with W750SR gateway for MQTT communication  
Serial a(D1,D0);
// Initializing RFID chip pins
MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);
  
    char c;
    int d;
    
int main(void) {
 
    Serial pc(USBTX, USBRX);
    Serial a(D1,D0);
    pc.printf("Wait a second...\r\n");
   
  //Init. RC522 Chip
  RfChip.PCD_Init();
 
  while (true) {
    //LedGreen = 1;
    pc.printf("enterd loop...\n");
    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(500);
      continue;
    }
   // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(500);
      continue;
    }
   
   char data[20]="";
  // char data1[20]="";
    
    // Print Card UID
    pc.printf("Card UID: ");
    printf("Size of UID: %d \n",RfChip.uid.size);
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      char temp[5];
      pc.printf(" %X02", RfChip.uid.uidByte[i]);
      sprintf(temp,"%X02", RfChip.uid.uidByte[i]);
      strcat(data,temp);
    }
    
    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    pc.printf(" \nPICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    wait_ms(1000);
    a.printf("%s",data);
  
  }
}
