#include "mbed.h"
#include "SPI.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"

#define ECHO_SERVER_PORT   7
 
Serial pc(USBTX, USBRX);   //Enabling the Serial transmission between WIZWIKI-W7500ECO and PC.
char c[100]="Hello testing";
 
int main(void) {
    printf("Wait a second...\r\n");
    char* topic = "ack";                    //if we are subscribing the acknowledgement.
    MQTTEthernet ipstack = MQTTEthernet();
    
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);
    
    char* hostname = "iot.eclipse.org";   //Give the IP Address of the MQTT Broker.
    int port = 1883;                  // Port number of the MQTT broker.  
    
 
    int rc = ipstack.connect(hostname, port);
    if (rc != 0)
    printf("rc from TCP connect is %d\n", rc);
    printf("Topic: %s\r\n",topic);
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    data.clientID.cstring = "Gintama";

    if ((rc = client.connect(data)) == 0)
    printf("rc from MQTT connect is %d\n", rc);
   
                              
   while (true) {
  
     pc.printf("The value Sent to MQTT is: %s \n ",c);
     MQTT::Message message;
     char buf[100];
     sprintf(buf, "%s", c);
     message.qos = MQTT::QOS0;
         message.retained = false;
         message.dup = false;

         message.payload = (void*)c;
         message.payloadlen = strlen(c);

         rc = client.publish("hellooo", message);
        // pc.printf("Rc result: %c \n ",rc);
         client.yield(60);
         wait(60);
    }
}
