//Test of cheap 13.56 Mhz RFID-RC522 module from eBay
//This code is based on Martin Olejar's MFRC522 library. Minimal changes
//Adapted for Nucleo STM32 F401RE. Should work on other Nucleos too

//Connect as follows:
//RFID pins        ->  Nucleo header CN5 (Arduino-compatible header)
//----------------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open
//RFID MISO=pin4   ->   Nucleo SPI_MISO=PA_6=D12
//RFID MOSI=pin3   ->   Nucleo SPI_MOSI=PA_7=D11
//RFID SCK=pin2    ->   Nucleo SPI_SCK =PA_5=D13
//RFID SDA=pin1    ->   Nucleo SPI_CS  =PB_6=D10
//RFID RST=pin7    ->   Nucleo         =PA_9=D8
//3.3V and Gnd to the respective pins

#include "mbed.h"
#include "MFRC522.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"
#include <sstream>
#include <string>
#define ECHO_SERVER_PORT   7


Serial out(USBTX,USBRX);
int arrivedcount = 0;
char RFIDTagMessage[20]="Hello!!!!!";

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    out.printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\n", message.qos, message.retained, message.dup, message.id);
    out.printf("Payload %.*s\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
}

void baud(int baudrate)
{
    Serial s(USBTX, USBRX);
    s.baud(baudrate);
}
char* store_buf;

int main(void)
{
    char* topic="arrive";
    out.printf("starting...\n");
    MQTTEthernet ipstack = MQTTEthernet();

   
          out.printf("\n\r");
        store_buf=RFIDTagMessage;
        out.printf("Stored variable: %s",store_buf);
        
     if(store_buf[10]!='\0') {
            MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);
            char* hostname = "172.16.73.4";
            int port = 1883;
            int rc = ipstack.connect(hostname, port);
            out.printf("rc from TCP connect is %d\n", rc);
            if (rc != 0)
            out.printf("rc from TCP connect is %d\n", rc);
            char MQTTClientID[30];
            MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
            data.MQTTVersion = 3;
            out.printf(MQTTClientID,"WIZwiki-W7500-client-%d",rand()%1000);
            data.clientID.cstring = MQTTClientID;
               data.username.cstring = "testuser";
               data.password.cstring = "testpassword"; 

        if ((rc = client.connect(data)) != 0)
               out.printf("rc from MQTT connect is %d\n", rc);
               
        if ((rc = client.subscribe(topic, MQTT::QOS1, messageArrived)) != 0)
        out.printf("rc from MQTT subscribe is %d\n", rc); 
      
      MQTT::Message message;
  
    while(true){
            message.qos = MQTT::QOS0;
            message.retained = false;
            message.dup = false;

            message.payload = (void*)RFIDTagMessage;
            message.payloadlen = strlen(RFIDTagMessage);

            rc = client.publish("test", message);
            out.printf("Rc result: % d ",rc);
         //  client.yield(60000);
        }
    }
}