
//Connect as follows:
//RFID pins, motor         
//----------------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open
//RFID MISO=pin4   ->   Nucleo SPI_MISO=PA_6=D12
//RFID MOSI=pin3   ->   Nucleo SPI_MOSI=PA_7=D11
//RFID SCK=pin2    ->   Nucleo SPI_SCK =PA_5=D13
//RFID SDA=pin1    ->   Nucleo SPI_CS  =PB_6=D10
//RFID RST=pin7    ->   Nucleo         =PA_9=D8
//3.3V and Gnd to the respective pins                              
// 1st Motor transistor  to Pin D9
// 2nd Motor transistor  to Pin D14
// Pin D0 to pin 2 of the serial Cable
// pin D1 to pin 3 of the serial cable
// pin A0 to the trigger of ultrasonic sensor 1
// pin A1 to the Echo of ultrasonic sensor 1                              
// pin D2 to RS pin of LCD
// pin D3 to E pin of LCD
// pin D4 to D4 pin of LCD
// pin D5 to D5 pin of LCD
// pin D6 to D6 pin of LCD
// pin D7 to D7 pin of LCD

//---------------------------------------------
#include "mbed.h"
#include "MFRC522.h"
#include "SPI.h"
#include "hcsr04.h"
#include "TextLCD.h"
#define ECHO_SERVER_PORT   7
#define SPI_MOSI D11
#define SPI_MISO D12
#define SPI_SCK D13
#define SPI_CS D10
#define MF_RESET D8
TextLCD lcd(D2, D3, D4, D5, D6, D7,TextLCD::LCD20x4); // rs, e, d4-d7
DigitalOut myled(D9);
DigitalOut myled1(D14);
//DigitalOut myled2(D15);    Can be enabled for 3rd motor slot.

HCSR04 sensor(A0,A1); // Trigger , Echo
HCSR04 sensor1(A2,A3); //Trigger , Echo
//HCSR04 sensor2(A4,A5); //Trigger , Echo   Can enable if needed for 3rd slot.

void distance();
void display();

//Serial connection to PC for output
Serial pc(USBTX, USBRX);
// Serial connection with WIZ750SR gateway for MQTT communication  
Serial serial(D1,D0);  //TX and RX
// Initializing RFID chip pins
MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);
    char c;
    int d;
int main(void) {
    pc.printf("starting...\n");
    myled=0;
    pc.printf("Wait a second...\r\n");
   
  //Init. RC522 Chip
  RfChip.PCD_Init();
 
  while (true) {
    pc.printf("enterd RFID reading loop...\n");
    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(500);
      continue;
    }
   // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(500);
      continue;
    }
   
   char data[20]="";
   char data1[20]="";
    
    // Print Card UID
    pc.printf("Card UID: ");
    printf("Size of UID: %d \n",RfChip.uid.size);
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      char temp[5];
      pc.printf(" %X02", RfChip.uid.uidByte[i]);
      sprintf(temp,"%X02", RfChip.uid.uidByte[i]);
      strcat(data,temp);
    }
    
    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    pc.printf(" \nPICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    wait_ms(1000);
    
    if(strcmp(data,"BA0211026102D302")==0)      //Comparing the stored data with the new data read by the RFID reader. 
    {   
        strcat(data1,"natsu");
        wait(1);
        serial.printf("%s",data1);
        wait(2);
        distance();
    }
    if(strcmp(data,"E8028002AC02E902")==0)
    {
        strcat(data1,"luffy");
        wait(1);
        serial.printf("%s",data1);
        wait(2);
        distance ();
    }
    pc.printf("The user name is :%s \n",data1);
   }
}


void distance()
{
     
    pc.printf("Entered into distance loop \n");
    while(1){
        long distance = sensor.distance();
        wait(0.5); 
        long distance1 = sensor1.distance();
        wait(0.5);
    //  long distance2 = sensor2.distance();             //can be enabled if connected to 3rd Ultrasonic sensor
        pc.printf("distance  %d  \n",distance);
        pc.printf("distance  %d  \n",distance1);
    //  pc.printf("distance  %d  \n",distance2);         //can be enabled if connected to 3rd Ultrasonic sensor to enable it in the PC.
        wait(1);
        
        wait(1.0); // 1 sec  
        if(distance<=10){
            myled= 1;
            wait(3);
            myled=0;
            serial.printf("/drink");
            c = '\0';
            c = 'd';
            d=15;
            display();
            pc.printf("/ item drink /cost 15");
            break;
            }
        else if(distance1<=10){
            myled1= 1;
            wait(3);
            myled1=0;
            serial.printf("/snack");
            c = '\0';
            c = 's';
            d=10;
            display();
            pc.printf("/item snack /cost 10");
            break;
          }
 /* else if(distance2<=10){
            myled1= 1;
            wait(30);
            myled1=0;
            serial.printf("/choco");
            c = '\0';
            c = 's';
            d=10;
            display();
            pc.printf("/snack/10");
            break;
          } */                                    //Can be enabled when 3rd ultrasonic is connected.
         
          }   
       }
       
                                 //function for LCD display ....
       
void display(){                                  
    lcd.locate(3,0);
    lcd.printf("Vending Machine\n");
    lcd.locate(0,2);
    if(c=='d'){
    lcd.printf("ITEM NAME: drink");
    }
    else if(c=='s')
    {
     lcd.printf("ITEM NAME: Snack");
    }
    lcd.locate(0,3);
    lcd.printf("ITEM COST: %d",d);
    }
