#include "mbed.h"
#include "GDEW075T8.h"
#include "DemoPixelSource.h"


DigitalOut nCS(PA_4);
DigitalOut nDC(PA_1);
DigitalOut nRST(PA_3);
DigitalIn ready(PA_0);
SPI spi(PA_7, PA_6, PA_5);

int main() {
    
    spi.frequency(4000000);
    
    GDE::DemoPixelSource *demoSource = new GDE::DemoPixelSource();
    
    GDE::setup(&nCS, &nDC, &nRST, &ready, &spi);
    GDE::start();
    
    while(true) {
        demoSource->setColor(false);
        GDE::showPixels(demoSource);
        demoSource->setColor(true);
        GDE::showPixels(demoSource);
    }
    
    GDE::stop();
}
