#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"
#include "GPS.h"

void button_pressed();   
void DrawChart(); 
void GetCartx(int elevace, int azimuth);  

    LCD_DISCO_F429ZI lcd;
    InterruptIn user_button(USER_BUTTON);
    DigitalOut led1(LED1);
    GPS gps(PC_12, PD_2);
    int hand = gps.sample();
    
    int16_t xs = 0;
    int16_t ys = 0;   
    uint8_t text[30];
    uint8_t screen = 1;

int main()
{      
    led1 = 1;
    uint16_t azimuth = 300;
    uint16_t elevace = 20;

    BSP_LCD_SetFont(&Font16);
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
  
    while(1)
    {         
      user_button.rise(&button_pressed);
      wait(0.3);
      led1 = !led1;
      hand = gps.sample();
if (hand == 1){     
    if(screen == 1){
        lcd.Clear(LCD_COLOR_BLACK)
        DrawChart();
        
        sprintf((char*)text, "Lat: %f %c", gps.latitude,gps.xns);
        lcd.DisplayStringAt(0, LINE(1), (uint8_t *)text, CENTER_MODE);
      
        sprintf((char*)text, "Lon: %f %c", gps.longitude,gps.xew);
        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)text, CENTER_MODE);
        
        sprintf((char*)text, "Sat. in view: %d", gps.siv);
        lcd.DisplayStringAt(0, LINE(3), (uint8_t *)text, CENTER_MODE);
        
        elevace = gps.svele1;
        azimuth = gps.svaz1;
        GetCartx(elevace, azimuth);
        //lcd.FillCircle(xs, ys, 4);
        lcd.DisplayChar(xs, ys, 65);
        
        elevace = gps.svele2;
        azimuth = gps.svaz2;
        GetCartx(elevace, azimuth);
        //lcd.FillCircle(xs, ys, 4);
        lcd.DisplayChar(xs, ys, 66);
      
        elevace = gps.svele3;
        azimuth = gps.svaz3;
        GetCartx(elevace, azimuth);
        //lcd.FillCircle(xs, ys, 4);
        lcd.DisplayChar(xs, ys, 67);
      
        elevace = gps.svele4;
        azimuth = gps.svaz4;
        GetCartx(elevace, azimuth);
        //lcd.FillCircle(xs, ys, 4);
        lcd.DisplayChar(xs, ys, 68);
        }
      
      if(screen == 2){
        sprintf((char*)text, "Sat.: PRN  AZ  ELE");
        lcd.DisplayStringAt(0, LINE(1), (uint8_t *)text, LEFT_MODE);
        
        sprintf((char*)text, "A:    %d  %d  %d", gps.prn1,gps.svaz1,gps.svele1);
        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)text, LEFT_MODE);
        
        sprintf((char*)text, "B:    %d  %d  %d", gps.prn2,gps.svaz2,gps.svele2);
        lcd.DisplayStringAt(0, LINE(3), (uint8_t *)text, LEFT_MODE);
        
        sprintf((char*)text, "C:    %d  %d  %d", gps.prn3,gps.svaz3,gps.svele3);
        lcd.DisplayStringAt(0, LINE(4), (uint8_t *)text, LEFT_MODE);
        
        sprintf((char*)text, "D:    %d  %d  %d", gps.prn4,gps.svaz4,gps.svele4);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)text, LEFT_MODE);
          }
      wait(0.05);
        }   
    } 
}

void button_pressed()
{
    if(screen == 1)
    {screen = 2;
    lcd.Clear(LCD_COLOR_BLACK);
    }
    else
    {screen = 1;
    lcd.Clear(LCD_COLOR_BLACK);
    DrawChart();
    }
}

void DrawChart()
{
      lcd.DrawLine(120, 90, 120, 310);
      lcd.DrawLine(10, 200, 250, 200);
      lcd.DrawCircle(120, 200, 100);
      lcd.DrawCircle(120, 200, 50);
    }

void GetCartx(int elevace, int azimuth) {
      float fazimuth = 0;
      float felevace = 0;
      uint16_t r = 0; 
      felevace = elevace/180.0f;
      fazimuth = azimuth/180.0f;
      
      r = 100*(cos(felevace*3.14159));
      xs = (r*cos(fazimuth*3.14159))+120;//0.49=14.7+120
      ys = (r*sin(fazimuth*3.15159))+200;//0.86=25.8+200
      
}