/* GPS class for mbed Microcontroller
 * Copyright (c) 2008, sford
 */

#include "mbed.h"

#ifndef GPS_H
#define GPS_H

/* Class: GPS
 *  A GPS interface for reading from a Globalsat EM-406 GPS Module
 */
class GPS {

public:

	/* Constructor: GPS
	 *  Create the GPS, connected to the specified serial port
	 */	
	GPS(PinName tx, PinName rx);
	
	/* Function: sample
	 *  Sample the incoming GPS data, returning whether there is a lock
	 * 
	 * Variables:
	 *  returns - 1 if there was a lock when the sample was taken (and therefore .longitude and .latitude are valid), else 0
	 */
	int sample();
	
	/* Variable: longitude
	 *  The longitude (call sample() to set)
	 */
	float longitude;

	/* Variable: latitude
	 *  The latitude (call sample() to set)
	 */
	float latitude;
	char xns;
	float xtime;
	char xew;
	int snum;
	
	int totmsg;
	int actmsg;
	int siv;
	int prn1;
	int svele1;
	int svaz1;
	int prn2;
	int svele2;
	int svaz2;
	int prn3;
	int svele3;
	int svaz3;
	int prn4;
	int svele4;
	int svaz4;
	/*
	int prn5;
	int svele5;
	int svaz5;
	int prn6;
	int svele6;
	int svaz6;
	int prn7;
	int svele7;
	int svaz7;
	int prn8;
	int svele8;
	int svaz8;
	*/
	int tempprn1;
	int tempsvele1;
	int tempsvaz1;
	int tempprn2;
	int tempsvele2;
	int tempsvaz2;
	int tempprn3;
	int tempsvele3;
	int tempsvaz3;
	int tempprn4;
	int tempsvele4;
	int tempsvaz4;
	
private:

	float trunc(float v);
	void getline();
	
	Serial _gps;
	char msg[256];

};

#endif
