/* GPS class for mbed Microcontroller
 * Copyright (c) 2008, sford
 */

#include "GPS.h"

GPS::GPS(PinName tx, PinName rx) : _gps(tx, rx) {
	_gps.baud(4800);	
	longitude = 0.0;
	latitude = 0.0;		
}


int GPS::sample() {
	float time;
	char ns, ew;
	int lock;

	while(1) {		
		getline();

		// Check if it is a GPGGA msg (matches both locked and non-locked msg)
		if(sscanf(msg, "GPGGA,%f,%f,%c,%f,%c,%d,%d", &time, &latitude, &ns, &longitude, &ew, &lock, &snum) >= 1) { 
			if(!lock) {
				longitude = 0.0;
				latitude = 0.0;		
				return 0;
			} else {
				if(ns == 'S') {	latitude  *= -1.0; }
				if(ew == 'W') {	longitude *= -1.0; }
				float degrees = trunc(latitude / 100.0f);
				float minutes = latitude - (degrees * 100.0f);
				latitude = degrees + minutes / 60.0f;	
				degrees = trunc(longitude / 100.0f * 0.01f);
				minutes = longitude - (degrees * 100.0f);
				longitude = degrees + minutes / 60.0f;
				xns = ns;
				xtime = time;
				xew = ew;
				//return 1;
			}
		}
		/*
		Parsing GSV message
		totmsg - total number of messages in cycle
		actmsg - message number
		siv - number of SVs in view
		prn	- SV PRN number
		svele - elevation
		svaz - azimuth
		*/
		if(sscanf(msg, "GPGSV,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d", &totmsg, &actmsg, &siv, &tempprn1, &tempsvele1, &tempsvaz1, &tempprn2, &tempsvele2, &tempsvaz2, &tempprn3, &tempsvele3, &tempsvaz3, &tempprn4, &tempsvele4, &tempsvaz4) >= 1) { 
			if(!lock) {
				totmsg = 0;
				actmsg = 0;	
				siv = 0;
				tempprn1 = 0;
				tempsvele1 = 0;
				tempsvaz1 = 0;	
				tempprn2 = 0;
				tempsvele2 = 0;
				tempsvaz2 = 0;	
				tempprn3 = 0;
				tempsvele3 = 0;
				tempsvaz3 = 0;	
				tempprn4 = 0;
				tempsvele4 = 0;
				tempsvaz4 = 0;	
				return 0;
			} else {
					if(actmsg==1){
						prn1 = tempprn1;
						svele1 = tempsvele1;
						svaz1 = tempsvaz1;	
						prn2 = tempprn2;
						svele2 = tempsvele2;
						svaz2 = tempsvaz2;	
						prn3 = tempprn3;
						svele3 = tempsvele3;
						svaz3 = tempsvaz3;	
						prn4 = tempprn4;
						svele4 = tempsvele4;
						svaz4 = tempsvaz4;	
						return 1;
						}
				//naznačené řešení pro příjem druhé čtveřice údají o satelitech
				/*if(actmsg==2){
						prn5 = tempprn1;
						svele5 = tempsvele1;
						svaz5 = tempsvaz1;	
						prn6 = tempprn2;
						svele6 = tempsvele2;
						svaz6 = tempsvaz2;	
						prn7 = tempprn3;
						svele7 = tempsvele3;
						svaz7 = tempsvaz3;	
						prn8 = tempprn4;
						svele8 = tempsvele4;
						svaz8 = tempsvaz4;	
						return 1;
						}*/
				
			}
		}
		
	}
}

float GPS::trunc(float v) {
	if(v < 0.0) {
		v*= -1.0;
		v = floor(v);
		v*=-1.0;
	} else {
		v = floor(v);
	}
	return v;
}

void GPS::getline() {
	while(_gps.getc() != '$');	// wait for the start of a line
	for(int i=0; i<256; i++) {
		msg[i] = _gps.getc();
		if(msg[i] == '\r') {
			msg[i] = 0;
			return;
		}
	}
	error("Overflowed message limit");
}

