/*The MIT License (MIT)

Copyright (c) <2015> <Kazumichi Aoki>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/



#include "mbed.h"
#include "PID.h"
#include "math.h"
#include "SB1602E.h"
#include "QEI.h"

//GPIO initilaize
AnalogIn    THAI(dp4);
PwmOut      out(dp18);
DigitalOut  ledR(dp17),ledG(dp25),ledB(dp26);
DigitalIn   RunPB(dp10);
Serial      pc(dp16, dp15); // tx, rx
Ticker      Timer_ticker;

/* PID constant initialize Kc, Ti, Td, interval */
#define P 5.0 //propotional band
#define I 2.0 //Integral
#define D 0.0 //Devide
#define RATE 0.1 //update time sec
#define InitialSP 45.0 // Boot Setpoint initial temeprature
#define Bias 0.0 //PID output bias
PID TIC(P, I, D, RATE);

/*LCD I2C pin initialize */
char *init_massage = "Hello!";
SB1602E lcd(dp5, dp27, init_massage);  //  SDA, SCL
/*QEI initialize */
#define ROTATE_PER_REVOLUTIONS  24
QEI wheel(dp11, dp13, NC, PullUp, ROTATE_PER_REVOLUTIONS, QEI::X2_ENCODING);

//Initial
float temp_sv_input;
bool Run(false);
double temp_pv,temp_cal;

/*PID SP encorder calcurate temperature */
#define EncoderDiv 20.0   //Divide encoder 1Pulse per 1℃ ex. 1/20=0.05 enc 1click 0.05C
#define RangeSPL    30.0    //Celcius low side temperature 
#define RangeSPH    100.0   //Celcius high side temperature
int encPulseCnt = ( (InitialSP - RangeSPL) * EncoderDiv );
int encPulses = 0;
int end_getPulses_old = 0;

/*PB control*/
void runmode()
{
    Run = !Run;
}

void TimerCall_10ms()
{
    static bool old_RunPB=0;
    bool tmp_RunPB=0;
    tmp_RunPB = RunPB;
    if( (old_RunPB != tmp_RunPB) && (tmp_RunPB == 1) ) {
        runmode();
    }
    old_RunPB = tmp_RunPB;
}

void cal_temp()
{
    /*SP temperature high low limit*/
    encPulseCnt = encPulseCnt + (encPulses - end_getPulses_old);
    if( encPulseCnt < 0 ) {                                 //Lower Limit
        encPulseCnt = 0;
    }
    if( encPulseCnt > ( (RangeSPH-RangeSPL) * EncoderDiv) ) { //Upper Limit
        encPulseCnt = (RangeSPH-RangeSPL) * EncoderDiv;
    }
    temp_sv_input = encPulseCnt / EncoderDiv + RangeSPL;    //calc encoder Pulse to SetPoint

    /*LCD Display section */
    lcd.printf(0,0, "SP %.1f", temp_sv_input);
}


int main()
{
    Timer_ticker.attach_us(&TimerCall_10ms, 10000);
    RunPB.mode(PullDown);
#define LCDCont 0x32 //LCD contrast set from 00 to 3f 64resolution defult set is 32step
    lcd.contrast(LCDCont);
    /* PWM setting.*/
    out.period(0.02);
    cal_temp();

    while (1) {
        encPulses = wheel.getPulses();
        if(end_getPulses_old != encPulses) {
            cal_temp();
        }
        end_getPulses_old = encPulses;

        /*LM26LVCISDX-115  Factory Preset Temperature Switch and Temperature Sensor Gain3 115C trip sensor calculation value.*/
        temp_cal = THAI.read() * 3300;
        temp_pv = -0.00000000007*pow(temp_cal,3.0)-0.000002*pow(temp_cal,2.0)-0.091*temp_cal+201.5;
        lcd.printf(0,1, "PV %.1f\n", temp_pv);
        /*Tenperature indicater */
        if (Run == true) {
            if ((temp_pv - temp_sv_input) >= 1.5) {
                ledR = 0;
                ledG = 1;
                ledB = 1;
                /* 1.5C low temperature */
            } else if ((temp_sv_input - temp_pv ) >= 1.5 ) {
                ledR = 1;
                ledG = 1;
                ledB = 0;
            } else {
                /* control green */
                ledR = 1;
                ledG = 0;
                ledB = 1;
            }
        } else {
            ledR = 1;
            ledG = 1;
            ledB = 1;
        }
        /*UART debug dispray*/
        printf("\033[1;1H");
        printf("OUT %.6f", out.read() * 100);
        printf("\033[1;20H");
        printf("Run %d\n", Run);
        printf("\033[2;1H");
        printf("PVTemp %.6f\n", temp_pv);
        printf("\033[2;20H");
        printf("SPTemp %.6f", temp_sv_input);
        printf("\033[3;1H");
        printf("PVread %.6f\n", THAI.read());
        printf("\033[3;20H");
        printf("PVTemp %.6f\n",encPulses );

        /*PID control*/

        /* Notice!!! PV_LL and PV_HH if incorrect value, PID output by dead lock.
                PV_LL= Temperature sensor low side value
                PV_HH= Temperature sensoe high side value*/
#define PV_LL -50.0 //PID PV low side Temp
#define PV_HH 150.0 //PID PV high side Temp
        TIC.setInputLimits(PV_LL, PV_HH);

        /*OV_LL OV_HH PID calcurate output range.
        If you use low power supply, you can limit output power. OV_HH is maximum 100%=65W at 24V */
#define OV_LL 0.0 //PID calcurate output value 0.0 = 0%
#define OV_HL 100.0 //PID calcurate output value 1.0 = 100%
        if (Run == true) {
            TIC.setOutputLimits(OV_LL, OV_HL);
            TIC.setSetPoint(temp_sv_input);
            TIC.setProcessValue(temp_pv);
            TIC.setBias(Bias); //control output bias
            TIC.setMode(1);
            out = TIC.compute() /100;
            TIC.setInterval(RATE);
        } else if (Run == false) {
            TIC.setMode(0);
            TIC.reset();
            out = 0.0;
        }
    }
}