#pragma O3

#include "FastIO.h"
#include "ili9328.h"
#include "stdio.h"
#include "string.h"
#include "SDFileSystem.h"
#include "VS1053.h"
#include "image.h"
#include "TouchPanel.h"
#include "mbed.h"

//(PinName CS, PinName RESET, PinName RS, PinName WR, BusOut *DATA_PORT, PinName BL=NC, PinName RD=NC, backlight_t blType=Constant, float defaultBackLightLevel=1.0)
//LCDのバスピンはTFTLCDライブラリ内のili9328.cpp内に記述する改変をしている
ILI9328_LCD lcd( P0_12, P0_11, P0_13, P0_14, NULL, NC, P1_9 ); // control pins and data bus

SDFileSystem sd(/*MOSI*/ P0_9, /*MISO*/ P0_8, /*SCK*/ P1_29, /*CS*/ P0_2, /*Mountpoint*/ "sd", NC, SDFileSystem::SWITCH_NONE, 20000000);

VS1053       mp3(/*MOSI*/ P1_22 , /*MISO*/ P1_21, /*SCK*/ P1_20, /*CS*/ P1_23,
                 /*BSYNC*/ P2_17, /*DREQ*/ P2_16, /*RST*/ P2_18, /*SPI freq.*/ 5000000);
Ticker Int10ms;

Serial pc(P0_19,P0_18);
#define SD_READ_BLOCK_SIZE (256)

//操作用ボタンの配置座標
#define BOTTON_PREV_XPOS    (15)
#define BOTTON_PREV_YPOS    (180)
#define BOTTON_PLAY_XPOS    (91)
#define BOTTON_PLAY_YPOS    (180)
#define BOTTON_STOP_XPOS    (168)
#define BOTTON_STOP_YPOS    (180)
#define BOTTON_NEXT_XPOS    (245)
#define BOTTON_NEXT_YPOS    (180)

//prevボタンのタッチ判定関数
bool checkTouchBotton_prev(int32_t xpos,int32_t ypos)
{
    bool result = 0;
    if( ( (xpos >= BOTTON_PREV_XPOS+5) && (xpos <= BOTTON_PREV_XPOS+55) ) &&
        ( (ypos >= BOTTON_PREV_YPOS+5) && (ypos <= BOTTON_PREV_YPOS+55) ) )
     {
         result = 1;
     }
     return result;
}

//playボタンのタッチ判定関数
bool checkTouchBotton_play(int32_t xpos,int32_t ypos)
{
    bool result = 0;
    if( ( (xpos >= BOTTON_PLAY_XPOS+5) && (xpos <= BOTTON_PLAY_XPOS+55) ) &&
        ( (ypos >= BOTTON_PLAY_YPOS+5) && (ypos <= BOTTON_PLAY_YPOS+55) ) )
     {
         result = 1;
     }
     return result;
}

//stopボタンのタッチ判定関数
bool checkTouchBotton_stop(int32_t xpos,int32_t ypos)
{
    bool result = 0;
    if( ( (xpos >= BOTTON_STOP_XPOS+5) && (xpos <= BOTTON_STOP_XPOS+55) ) &&
        ( (ypos >= BOTTON_STOP_XPOS+5) && (ypos <= BOTTON_STOP_XPOS+55) ) )
     {
         result = 1;
     }
     return result;
}

//nextボタンのタッチ判定関数
bool checkTouchBotton_next(int32_t xpos,int32_t ypos)
{
    bool result = 0;
    if( ( (xpos >= BOTTON_NEXT_XPOS+5) && (xpos <= BOTTON_NEXT_XPOS+55) ) &&
        ( (ypos >= BOTTON_NEXT_YPOS+5) && (ypos <= BOTTON_NEXT_YPOS+55) ) )
     {
         result = 1;
     }
     return result;
}

//どのボタンが押されたかの定義
#define TOUCHPANEL_BOTTON_TOUCH_STOP    (0)
#define TOUCHPANEL_BOTTON_TOUCH_PLAY    (1)
#define TOUCHPANEL_BOTTON_TOUCH_NEXT    (2)
#define TOUCHPANEL_BOTTON_TOUCH_PREV    (3)
#define TOUCHPANEL_BOTTON_TOUCH_VOLUP   (4)
#define TOUCHPANEL_BOTTON_TOUCH_VOLDOWN (5)
#define TOUCHPANEL_BOTTON_NOT_TOUCH     (-1)
#define TOUCHPANEL_OTHER_TOUCH          (-2)

//タッチ検出用関数
int8_t detectTouchBotton(int32_t xpos,int32_t ypos)
{
    int8_t         result = 0;

    if( checkTouchBotton_stop(xpos,ypos) )
    {
        result = TOUCHPANEL_BOTTON_TOUCH_STOP;
    }
    else if( checkTouchBotton_play(xpos,ypos) )
    {
        result = TOUCHPANEL_BOTTON_TOUCH_PLAY;
    }
    else if( checkTouchBotton_prev(xpos,ypos) )
    {
        result = TOUCHPANEL_BOTTON_TOUCH_PREV;
    }
    else if( checkTouchBotton_next(xpos,ypos) )
    {
        result = TOUCHPANEL_BOTTON_TOUCH_NEXT;
    }
    else if( (xpos == -1) || (ypos == -1) )
    {
        result = TOUCHPANEL_BOTTON_NOT_TOUCH;
    }
    else
    {
        result = TOUCHPANEL_OTHER_TOUCH;
    }
    
    return result;    
}

uint8_t     g_mp3Player_State = 0;
uint16_t    g_mp3Player_Volume = 0;
bool        gf_mp3Playwe_VolmeUpdate = 0;
bool        gf_TimerInt = 0;

void Int10msFunc()
{
    gf_TimerInt = 1;
}

int main()
{
    static FILE *fp = NULL;
    uint8_t     SDFileOpenFailCnt = 0;
    size_t      mp3_ReadFileSize = 0;
    size_t      mp3_totalSizeSent=0;
    size_t      mp3_fileSize=0;
    bool        f_mp3Playwe_Playing = 0;
    uint8_t     buf[SD_READ_BLOCK_SIZE];
    char        str[100];
    int32_t     XReadPos = 0,YReadPos = 0;
    uint32_t    aveXReadPos = 0,aveYReadPos = 0;
    uint8_t     c_TouchPanelAve = 0;
    bool        touchPanel_Touched = 0;
    uint32_t    totalPlay = 0;
    int         dot1_FileSize = 0;
    int         dot_XPos = 0,old_dot_XPos = 0;
    int         lcd_FileViewPage = 0,old_lcd_FileViewPage = 0;
    int         lcd_FileViewListEnd = 0;

                                          //Format,Xsize,Ysize,PixelData
    const bitmap_t img_button_play      = { RGB16, 60, 60, &bmp_button_play };
    const bitmap_t img_button_stop      = { RGB16, 60, 60, &bmp_button_stop };
    const bitmap_t img_button_next      = { RGB16, 60, 60, &bmp_button_next };
    const bitmap_t img_button_prev      = { RGB16, 60, 60, &bmp_button_prev };
    const bitmap_t img_button_pause     = { RGB16, 60, 60, &bmp_button_pause };

    pc.baud(921600);
    printf("Power ON\r\n");

    Int10ms.attach_us(&Int10msFunc, 10000);

    //SD Init.(本来ならいらないけど、SDカードによっちゃもう１回リセットしないとアクセスできない場合あり
    sd.disk_initialize();
    printf("SDCard inited.\r\n"); 

    //LCD Init.
    lcd.Initialize(LANDSCAPE,RGB16);
    printf("LCD inited.\r\n"); 

/* for sine test mode */
//    mp3.sine_test_activate(SineWave_10k);
//    while(1);

    //MP3 decoder Init.
    mp3.hardwareReset();
    mp3.sci_init();
    mp3.sdi_init();
    wait(0.1);
    printf("VS1033 inited.\r\n"); 
    printf("init CMPL.\r\n"); 

    //バックスクリーン色を青色に指定し、画面全体をバックスクリーン色で塗りつぶし
    lcd.SetBackground(COLOR_BLUE);
    lcd.FillScreen(-1);
    //フォント指定
    lcd.SetFont( &TerminusBigFont );

  //for Caliblation
    while(0)
    {
        int32_t     XReadPos = 0,YReadPos = 0;
        lcd.DrawCircle(40,40,10,COLOR_WHITE);
        lcd.DrawCircle(280,200,10,COLOR_WHITE);
        XReadPos = getTouchPanelPosX();
        YReadPos = getTouchPanelPosY();
        printf("X:%d Y:%d\r\n",XReadPos,YReadPos);
        wait_ms(500);
    }

    //MP3プレイヤー操作用ボタンを配置
                    //Xpos, Ypos, ImageData(type:bitmap_t), Scale
    lcd.DrawBitmap( BOTTON_PREV_XPOS,    BOTTON_PREV_YPOS,    (const bitmap_t*)&img_button_prev, 1 );
    lcd.DrawBitmap( BOTTON_PLAY_XPOS,    BOTTON_PLAY_YPOS,    (const bitmap_t*)&img_button_play, 1 );
    lcd.DrawBitmap( BOTTON_STOP_XPOS,    BOTTON_STOP_YPOS,    (const bitmap_t*)&img_button_stop, 1 );
    lcd.DrawBitmap( BOTTON_NEXT_XPOS,    BOTTON_STOP_YPOS,    (const bitmap_t*)&img_button_next, 1 );

////////////////////////////////////////////////////////////
/*  SDCard GetFileList Section                            */
////////////////////////////////////////////////////////////
#define SD_MAX_FILENAME_LENGTH  (256)   //MAX 256
#define SD_MAX_FILE_COUNT       (50)

    char SDFileList[SD_MAX_FILE_COUNT][SD_MAX_FILENAME_LENGTH]={0};
    char SDFileList_short[SD_MAX_FILE_COUNT][SD_MAX_FILENAME_LENGTH]={0};
    char SDFileList_cnt = 0;
    char mp3PlayingFileName[SD_MAX_FILENAME_LENGTH]={0};
    uint8_t mp3PlayingFileNo = 0;
    int i = 0;
    DIR *d;
    struct dirent *p;

    d = opendir("/sd");
    if ( d != NULL )
    {
        while ( (p = readdir(d)) != NULL )  //SDカード内のファイル一覧を取得
        {
            char *ret;
            ret = strstr(p->d_name,"System");   //System Vol..フォルダは除外
            if(ret == 0)
            {
                sprintf((char *)(SDFileList_short[i]+0),"%s",(const char *)p->d_name);
                sprintf((char *)(SDFileList[i]+0),"/sd/%s",(const char *)p->d_name);
                printf("FileFound:%d,%s\r\n",i,SDFileList[i]);
                i+=1;
            }
        }
        SDFileList_cnt = i;
    }
    closedir(d);

//MP3プレイヤーの状態遷移定義
//g_mp3Player_State変数にて使用
#define MP3_STATE_STOPPING      (0)
#define MP3_STATE_STOPREQ       (1)
#define MP3_STATE_PLAYREQ       (2)
#define MP3_STATE_PLAYING       (3)
#define MP3_STATE_NEXTREQ       (4)
#define MP3_STATE_PREVREQ       (5)
#define MP3_STATE_VOLCHANGEREQ  (6)
#define MP3_STATE_REPLAY        (7)
#define MP3_STATE_FILECHANGE    (8)
#define MP3_STATE_PAUSEREQ      (9)
#define MP3_STATE_PAUSEING      (10)
#define MP3_STATE_RESUMEREQ     (11)
    
    printf("file count=%d\r\n",SDFileList_cnt);

    mp3PlayingFileNo = 0;
    g_mp3Player_State = MP3_STATE_FILECHANGE;
    f_mp3Playwe_Playing = 0;
    lcd.Print("STOP      ",15,145);
    //プログレスバーの描画
    lcd.DrawRect(135,155,310,165,COLOR_WHITE);
    lcd.FillRect(136,156,309,164,COLOR_BLUE);

    while(1)
    {

//////////////////////////////////////////////////////////////
/*  TouchPanel GetStatas Section                            */
//////////////////////////////////////////////////////////////
        if(gf_TimerInt == 1)    //10msタイマのフラグが立っていたらタッチパネル読み込みを行う
        {
            gf_TimerInt = 0;

            XReadPos = getTouchPanelPosX();
            YReadPos = getTouchPanelPosY();

            if( detectTouchBotton(XReadPos,YReadPos) == TOUCHPANEL_BOTTON_NOT_TOUCH )
            {
                c_TouchPanelAve = 0;
                touchPanel_Touched = 0;
                aveXReadPos = 0;
                aveYReadPos = 0;
            }
            #define TOUCHPANEL_AVERAGE_COUNT (5)        //5回読んだタッチパネル座標の平均値を取得
            else if(c_TouchPanelAve <= TOUCHPANEL_AVERAGE_COUNT)
            {
                printf("X:%d Y:%d\r\n",XReadPos,YReadPos);
                aveXReadPos = aveXReadPos + XReadPos;
                aveYReadPos = aveYReadPos + YReadPos;
                c_TouchPanelAve++;
            }
            if(c_TouchPanelAve == TOUCHPANEL_AVERAGE_COUNT)
            {
                aveXReadPos = aveXReadPos/TOUCHPANEL_AVERAGE_COUNT;
                aveYReadPos = aveYReadPos/TOUCHPANEL_AVERAGE_COUNT;
                c_TouchPanelAve = (TOUCHPANEL_AVERAGE_COUNT+1);
                printf("Xave:%d Yave:%d\r\n",aveXReadPos,aveYReadPos);
            }
            if(c_TouchPanelAve == (TOUCHPANEL_AVERAGE_COUNT+1) )    //平均値を元にどのボタンが押されたか判定
            {
                switch( detectTouchBotton(aveXReadPos,aveYReadPos) )
                {
                    case TOUCHPANEL_BOTTON_TOUCH_PREV:
                        if(touchPanel_Touched == 0)
                        {
                            printf("prev touch\r\n");
                            g_mp3Player_State = MP3_STATE_PREVREQ;
                            touchPanel_Touched = 1;
                        }
                        break;
                    case TOUCHPANEL_BOTTON_TOUCH_PLAY:
                        if(touchPanel_Touched == 0)
                        {
                            printf("play touch\r\n");
                            if( (g_mp3Player_State == MP3_STATE_STOPPING) )
                            {
                                g_mp3Player_State = MP3_STATE_PLAYREQ;
                                printf("MP3_STATE_PLAYREQ\r\n");
                            }
                            if( g_mp3Player_State == MP3_STATE_PLAYING )
                            {
                                g_mp3Player_State = MP3_STATE_PAUSEREQ;
                                printf("MP3_STATE_PAUSEREQ\r\n");
                            }
                            if( g_mp3Player_State == MP3_STATE_PAUSEING )
                            {
                                g_mp3Player_State = MP3_STATE_RESUMEREQ;
                                printf("MP3_STATE_RESUMEREQ\r\n");
                            }
    
                            touchPanel_Touched = 1;
                        }
                        break;
                    case TOUCHPANEL_BOTTON_TOUCH_STOP:
                        if(touchPanel_Touched == 0)
                        {
                            printf("stop touch\r\n");
                            if( (g_mp3Player_State != MP3_STATE_STOPPING) && (g_mp3Player_State != MP3_STATE_STOPREQ) )
                            {
                                g_mp3Player_State = MP3_STATE_STOPREQ;
                            }
                            touchPanel_Touched = 1;
                        }
                        break;
                    case TOUCHPANEL_BOTTON_TOUCH_NEXT:
                        if(touchPanel_Touched == 0)
                        {
                            printf("next touch\r\n");
                            g_mp3Player_State = MP3_STATE_NEXTREQ;
                            touchPanel_Touched = 1;
                        }
                        break;
                    case TOUCHPANEL_OTHER_TOUCH:
                        //printf("otherTouch\r\n");
                        //printf("X:%d Y:%d\r\n",XReadPos,YReadPos);
                        break;
                    case TOUCHPANEL_BOTTON_NOT_TOUCH:
                        //printf("notTouch\r\n");
                        touchPanel_Touched = 0;
                        break;
                    default :
                        break;
                }
            }
        }

//////////////////////////////////////////////////////////////
/*  MP3 Player Control Section                              */
//////////////////////////////////////////////////////////////
        switch(g_mp3Player_State)
        {
            case MP3_STATE_PLAYREQ:
            {
                printf("FileOpen:%s\r\n",mp3PlayingFileName);
                fp = fopen(mp3PlayingFileName, "rb");
                SDFileOpenFailCnt = 0;
                while(!fp)
                {
                    SDFileOpenFailCnt+=1;
                    if(SDFileOpenFailCnt >= 3)
                    {
                        printf("Fail SD init\r\n");
                        printf("System Stop.\r\n");
                        NVIC_SystemReset();
                    }
                    printf("Fail file open n=%d\r\n",SDFileOpenFailCnt);
                    sd.disk_initialize();
                    fp = fopen(mp3PlayingFileName, "rb");
                    wait(1);
                }
    
                //Get file size
                fseek( fp, 0, SEEK_END );
                mp3_fileSize = ftell( fp );
                printf("FileOpen. size=%dbit\r\n",mp3_fileSize);
    
                //move file pointer to top.
                rewind(fp);
                clearerr(fp);
                mp3_totalSizeSent = 0;
                lcd.Print("Playing   ",15,145);
    
                lcd.DrawRect(135,155,310,165,COLOR_WHITE);
                lcd.FillRect(136,156,309,164,COLOR_BLUE);
                dot1_FileSize = mp3_fileSize/175;           
    
                g_mp3Player_State = MP3_STATE_PLAYING;
                lcd.DrawBitmap( BOTTON_PLAY_XPOS,    BOTTON_PLAY_YPOS,    (const bitmap_t*)&img_button_pause, 1 );
    
                totalPlay++;
                printf("PlayCount=%d\r\n",totalPlay);
                break;
            }
            case MP3_STATE_PLAYING:
            {
                if(mp3_totalSizeSent>=mp3_fileSize) //play song end
                {
                    f_mp3Playwe_Playing = 1;
                    g_mp3Player_State = MP3_STATE_NEXTREQ;  //next song
                }
                else                                //transmit from SDCard to VS1033
                {
                    if( mp3.checkDREQ() == 1 )
                    {                   
                        mp3_ReadFileSize = fread(buf, sizeof(uint8_t), SD_READ_BLOCK_SIZE, fp);
                        mp3_totalSizeSent += mp3.sendDataBlock(buf, mp3_ReadFileSize);
                        dot_XPos = mp3_totalSizeSent / dot1_FileSize;
                        if(old_dot_XPos != dot_XPos)
                        {
                            lcd.DrawLine(135+dot_XPos, 156, 135+dot_XPos, 164); //x1:135 y1:155 x2:310 y3:165
                        }
                        old_dot_XPos = dot_XPos;
                        //printf("SendedSize:%d LinePos:%d\r\n",mp3_totalSizeSent,dot_XPos);
                        //printf(" HDAT0:0x%x HDAT1:0x%x\r\n",mp3.readReg(mp3.SCI_HDAT0),mp3.readReg(mp3.SCI_HDAT1));
                    }
                    f_mp3Playwe_Playing = 1;
                }
                break;
            }
            case MP3_STATE_PAUSEREQ:
            {
                lcd.DrawBitmap( BOTTON_PLAY_XPOS,    BOTTON_PLAY_YPOS,    (const bitmap_t*)&img_button_play, 1 );
                g_mp3Player_State = MP3_STATE_PAUSEING;
                break;
            }
            case MP3_STATE_PAUSEING:
            {
                break;
            }
            case MP3_STATE_RESUMEREQ:
            {
                lcd.DrawBitmap( BOTTON_PLAY_XPOS,    BOTTON_PLAY_YPOS,    (const bitmap_t*)&img_button_pause, 1 );
                g_mp3Player_State = MP3_STATE_PLAYING;
                break;
            }
        
            case MP3_STATE_STOPREQ:
            case MP3_STATE_REPLAY:
            {
                uint16_t returnCode=0;
                uint16_t stopFailCnt = 0;
                uint16_t readHDAT0,readHDAT1;
    
                lcd.Print("STOP      ",15,145);
                lcd.DrawRect(135,155,310,165,COLOR_WHITE);
                lcd.FillRect(136,156,309,164,COLOR_BLUE);
                lcd.DrawBitmap( BOTTON_PLAY_XPOS,    BOTTON_PLAY_YPOS,    (const bitmap_t*)&img_button_play, 1 );
    
                do
                {
                    returnCode = mp3.stop();
                    readHDAT0 = mp3.readReg(mp3.SCI_HDAT0);
                    readHDAT1 = mp3.readReg(mp3.SCI_HDAT1);
                    returnCode = readHDAT0||readHDAT1;
    
                    printf("STOP\r\nSTOP CODE:%d\r\n",returnCode);
                    printf(" HDAT0:0x%x HDAT1:0x%x\r\n",readHDAT0,readHDAT1);
    
                    if(returnCode != 0 )
                    {
                        stopFailCnt++;
                    }
                    if(stopFailCnt >= 20)
                    {
                        printf("ERROR! impossible of stop\r\nVS1033 Reset\r\n");
                        mp3.hardwareReset();
                        mp3.sci_init();
                        mp3.sdi_init();
                        wait(1);
                        stopFailCnt = 0;
                        returnCode = 0;
                    }
                }while(returnCode != 0);
    
                fclose(fp);
                fp = NULL;
                f_mp3Playwe_Playing = 0;
    
                if(g_mp3Player_State == MP3_STATE_STOPREQ)
                {
                    g_mp3Player_State = MP3_STATE_STOPPING;
                }
                if(g_mp3Player_State == MP3_STATE_REPLAY)
                {
                    g_mp3Player_State = MP3_STATE_PLAYREQ;
                }
                break;
            }
            case MP3_STATE_STOPPING:
            {
                f_mp3Playwe_Playing = 0;
                break;
            }
            case MP3_STATE_NEXTREQ:
            {
                if( mp3PlayingFileNo >= (SDFileList_cnt -1) )
                {
                    mp3PlayingFileNo = 0;
                }
                else
                {
                    mp3PlayingFileNo+=1;
                }
                g_mp3Player_State = MP3_STATE_FILECHANGE;
                break;
            }
            case MP3_STATE_PREVREQ:
            {
                if( mp3PlayingFileNo <= 0 )
                {
                    mp3PlayingFileNo = (SDFileList_cnt - 1);
                }
                else
                {
                    mp3PlayingFileNo-=1;
                }
                g_mp3Player_State = MP3_STATE_FILECHANGE;
                break;
            }

            case MP3_STATE_FILECHANGE:
            {
                printf("next:%d,%s\r\n",mp3PlayingFileNo,SDFileList[mp3PlayingFileNo]);
    
                lcd_FileViewPage = mp3PlayingFileNo/5;
                if(old_lcd_FileViewPage != lcd_FileViewPage)
                {
                    lcd.FillRect(0,0,320,140,COLOR_BLUE);
                }
                old_lcd_FileViewPage = lcd_FileViewPage;
    
                if(SDFileList_cnt >= 5)
                {
                    if( (SDFileList_cnt-(5*lcd_FileViewPage)) >= 5 )
                    {
                        lcd_FileViewListEnd = (5*lcd_FileViewPage+5);
    
                    }
                    else
                    {
                        lcd_FileViewListEnd = (5*lcd_FileViewPage+ ((SDFileList_cnt-(5*lcd_FileViewPage))%5) );
                    }
                    printf("FilePage:%d max:%d\r\n",lcd_FileViewPage, lcd_FileViewListEnd);
    
                    for(i=(5*lcd_FileViewPage); i<lcd_FileViewListEnd; i++)
                    {
                        sprintf(str,"%d:%s",i,SDFileList_short[i]);
                        lcd.Print( str, LEFT, (i%5)*28 ); // align text to center horizontally and use starndard colors
                    }
                }
                else
                {
                    for(i=0;i<SDFileList_cnt;i++)
                    {
                        sprintf(str,"%d:%s",i,SDFileList_short[i]);
                        lcd.Print( str, LEFT, i*28 ); // align text to center horizontally and use starndard colors
                    }
                }

                sprintf(str,"%d:%s",mp3PlayingFileNo,SDFileList_short[mp3PlayingFileNo]);
                lcd.Print( str, LEFT, 28*(mp3PlayingFileNo%5),COLOR_YELLOW,-1,0 ); // align text to center horizontally and use starndard colors
                if(mp3PlayingFileNo >= 10)
                {
                    lcd.Print( "**", LEFT, 28*(mp3PlayingFileNo%5),COLOR_YELLOW,-1,0); // align text to center horizontally and use starndard colors
                }
                else
                {
                    lcd.Print( "*", LEFT, 28*(mp3PlayingFileNo%5),COLOR_YELLOW,-1,0 ); // align text to center horizontally and use starndard colors
                }
                
                sprintf(mp3PlayingFileName,"%s",SDFileList[mp3PlayingFileNo]);
                if(f_mp3Playwe_Playing == 1)
                {
                    g_mp3Player_State = MP3_STATE_REPLAY;
                }
                else
                {
                    g_mp3Player_State = MP3_STATE_STOPPING;
                }
                break;
            }
            default:
            {
                break;
            }
        }
    }    
}
