#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"

#define CHART_SIZE 64

Ticker timer;
AnalogOut vout(PTE30);
SLCD slcd;
TSISensor tsi;
InterruptIn amp_up(SW1);
InterruptIn amp_down(SW3);

float amplitude = 0;
float freq = 20;
static int phase = 0;
static float sinwave[CHART_SIZE] = {
    0.5000,0.5490,0.5975,0.6451,0.6913,0.7357,0.7778,0.8172,0.8536,0.8865,
    0.9157,0.9410,0.9619,0.9785,0.9904,0.9976,1.0000,0.9976,0.9904,0.9785,
    0.9619,0.9410,0.9157,0.8865,0.8536,0.8172,0.7778,0.7357,0.6913,0.6451,
    0.5975,0.5490,0.5000,0.4510,0.4025,0.3549,0.3087,0.2643,0.2222,0.1828,
    0.1464,0.1135,0.0843,0.0590,0.0381,0.0215,0.0096,0.0024,0.0000,0.0024,
    0.0096,0.0215,0.0381,0.0590,0.0843,0.1135,0.1464,0.1828,0.2222,0.2643,
    0.3087,0.3549,0.4025,0.4510};
void timer_int();
void display(float val);
void amp_up_int();
void amp_down_int();


void timer_int(){
    phase++;
    if(phase >= CHART_SIZE)
        phase = 0;
    vout = amplitude*sinwave[phase];
}

void amp_up_int(){
    if(amplitude <= 0.95){
        amplitude += 0.05;
        display(amplitude*3.3);
    }
}

void amp_down_int(){
    if(amplitude >= 0.05){
        amplitude -= 0.05;
        display(amplitude*3.3);
    }   
}

void display(float val){
    char buf[16];
    int tmp = int(val*100);
    sprintf(buf,"%d%d%d",tmp/100,(tmp%100)/10,tmp%10);
    slcd.printf(buf);
    slcd.Home();
}

int main(){
    amp_up.rise(amp_up_int);
    amp_down.rise(amp_down_int);
    slcd.DP1(1);
    display(amplitude*3.3);
    timer.attach(&timer_int, 1/freq);
    while(true){
        if(tsi.readPercentage()!=0){
            freq = 50 * tsi.readPercentage();
            timer.attach(&timer_int, 1/freq);
        }
        wait(0.05);
    } 
}