/**
 ******************************************************************************
 * @file    x_nucleo_6180xa1.h
 * @author  AST / EST
 * @version V0.0.1
 * @date    13-April-2015
 * @brief   Header file for class X_NUCLEO_6180XA1 representing a X-NUCLEO-6180XA1
 *          expansion board
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */

/* Define to prevent from recursive inclusion --------------------------------*/
#ifndef __X_NUCLEO_6180XA1_H
#define __X_NUCLEO_6180XA1_H

/* Includes ------------------------------------------------------------------*/
#include "mbed.h"
#include "vl6180x_class.h"
#include "Display_class.h"
#include "STMPE1600_class.h"
#include "DevI2C.h"

/** New device addresses */
#define NEW_SENSOR_TOP_ADDRESS			0x10
#define NEW_SENSOR_BOTTOM_ADDRESS		0x11
#define NEW_SENSOR_LEFT_ADDRESS			0x12
#define NEW_SENSOR_RIGHT_ADDRESS		0x13

/* Classes--------------------------------------------------------------------*/

class X_NUCLEO_6180XA1
{
 public:
    X_NUCLEO_6180XA1(DevI2C *ext_i2c) : dev_i2c(ext_i2c)
    {
       digit1=new STMPE1600DigiOut(*dev_i2c, GPIO_7);
       digit2=new STMPE1600DigiOut(*dev_i2c, GPIO_8);
       digit3=new STMPE1600DigiOut(*dev_i2c, GPIO_9);
       digit4=new STMPE1600DigiOut(*dev_i2c, GPIO_10);			
			
       dispA=new STMPE1600DigiOut(*dev_i2c, GPIO_0);			
       dispB=new STMPE1600DigiOut(*dev_i2c, GPIO_1);			
       dispC=new STMPE1600DigiOut(*dev_i2c, GPIO_2);			
       dispD=new STMPE1600DigiOut(*dev_i2c, GPIO_3);			
       dispE=new STMPE1600DigiOut(*dev_i2c, GPIO_4);			
       dispF=new STMPE1600DigiOut(*dev_i2c, GPIO_5);			
       dispG=new STMPE1600DigiOut(*dev_i2c, GPIO_6);						
       //display=new Display(*digit1,*digit2,*digit3,*digit4,*dispA,*dispB,*dispC,*dispD,*dispE,*dispF,*dispG);
       display=new Display(*ext_i2c);

       gpio0_top=new STMPE1600DigiOut(*dev_i2c, GPIO_12);
       sensor_top=new VL6180X(*dev_i2c, *gpio0_top, PB_0);
       
       gpio0_bottom=new STMPE1600DigiOut(*dev_i2c, GPIO_13);
       sensor_bottom=new VL6180X(*dev_i2c, *gpio0_bottom, PA_4);
       
       gpio0_left=new STMPE1600DigiOut(*dev_i2c, GPIO_14);
       sensor_left=new VL6180X(*dev_i2c, *gpio0_left, PA_5);
       
       gpio0_right=new STMPE1600DigiOut(*dev_i2c, GPIO_15);
       sensor_right=new VL6180X(*dev_i2c, *gpio0_right, PA_10);
    }
		
    ~X_NUCLEO_6180XA1()
    {
       if(gpio0_top!=NULL)
       {
          delete gpio0_top;
          gpio0_top=NULL;
       }
       if(sensor_top!=NULL)
       {
          delete sensor_top;
	  sensor_top=NULL;
       }
       if(gpio0_bottom!=NULL)
       {
          delete gpio0_bottom;
          gpio0_bottom=NULL;
       }
       if(sensor_bottom!=NULL)
       {
          delete sensor_bottom;
	  sensor_bottom=NULL;
       }
       if(gpio0_left!=NULL)
       {
          delete gpio0_left;
          gpio0_left=NULL;
       }
       if(sensor_left!=NULL)
       {
          delete sensor_left;
	  sensor_left=NULL;
       }
       if(gpio0_left!=NULL)
       {
          delete gpio0_left;
          gpio0_left=NULL;
       }
       if(sensor_left!=NULL)
       {
          delete sensor_left;
	  sensor_left=NULL;
       }
       if(gpio0_right!=NULL)
       {
          delete gpio0_right;
          gpio0_right=NULL;
       }
       if(sensor_right!=NULL)
       {
          delete sensor_right;
	  sensor_right=NULL;
       }
    }
		  
    DevI2C *dev_i2c;
        
    VL6180X *sensor_top;
    VL6180X *sensor_bottom;
    VL6180X *sensor_left;
    VL6180X *sensor_right;
    
    STMPE1600DigiOut *gpio0_top;
    STMPE1600DigiOut *gpio0_bottom;
    STMPE1600DigiOut *gpio0_left;
    STMPE1600DigiOut *gpio0_right;

    
    STMPE1600DigiOut *digit1;
    STMPE1600DigiOut *digit2;
    STMPE1600DigiOut *digit3;
    STMPE1600DigiOut *digit4;		
		
    STMPE1600DigiOut *dispA;		
    STMPE1600DigiOut *dispB;
    STMPE1600DigiOut *dispC;
    STMPE1600DigiOut *dispD;
    STMPE1600DigiOut *dispE;
    STMPE1600DigiOut *dispF;
    STMPE1600DigiOut *dispG;

    Display *display;
		
    static X_NUCLEO_6180XA1 *Instance(DevI2C *ext_i2c);
		
    int InitBoard();
		
 private:
    static X_NUCLEO_6180XA1 *_instance;
};

#endif /* __X_NUCLEO_6180XA1_H */
