/**
 ******************************************************************************
 * @file    vl6180x_class.h
 * @author  AST / EST
 * @version V0.0.1
 * @date    14-April-2015
 * @brief   Header file for component VL6180X
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/
#ifndef     __STMPE1600_CLASS
#define     __STMPE1600_CLASS
/* Includes ------------------------------------------------------------------*/
#include    "DevI2C.h"

#define STMPE1600_DEF_DEVICE_ADDRESS  (uint8_t)0x42*2   
#define STMPE1600_DEF_DIGIOUT_LVL      1

/**  STMPE1600 registr map **/
#define VersionId       (uint8_t)0x02
#define SystemControl   (uint8_t)0x03
#define IEGPIOR_0_7	(uint8_t)0x08
#define IEGPIOR_8_15	(uint8_t)0x09
#define ISGPIOR_0_7	(uint8_t)0x0A
#define ISGPIOR_8_15	(uint8_t)0x0B
#define GPMR_0_7	(uint8_t)0x10
#define GPMR_8_15	(uint8_t)0x11
#define GPSR_0_7	(uint8_t)0x12
#define GPSR_8_15	(uint8_t)0x13
#define GPDR_0_7	(uint8_t)0x14
#define GPDR_8_15	(uint8_t)0x15
#define GPIR_0_7	(uint8_t)0x16
#define GPIR_8_15	(uint8_t)0x17

  typedef enum {
    // GPIO Expander pin names
    GPIO_0=0,
    GPIO_1,
    GPIO_2,
    GPIO_3,            
    GPIO_4,
    GPIO_5,
    GPIO_6,
    GPIO_7,            
    GPIO_8,
    GPIO_9,
    GPIO_10,
    GPIO_11,            
    GPIO_12,
    GPIO_13,
    GPIO_14,
    GPIO_15
} ExpGpioPinName;   

typedef enum {
    INPUT = 0,
    OUTPUT,
    NOT_CONNECTED
}ExpGpioPinDirection;


class STMPE1600DigiOut {
	
 public: 
    STMPE1600DigiOut (DevI2C &i2c, ExpGpioPinName outpinname, uint8_t DevAddr=STMPE1600_DEF_DEVICE_ADDRESS, bool lvl=STMPE1600_DEF_DIGIOUT_LVL): dev_i2c(i2c), expdevaddr(DevAddr), exppinname(outpinname) 
    {
       uint8_t data[2];				
       /* set the exppinname as output */
       dev_i2c.i2c_read(data, expdevaddr, GPDR_0_7, 1);
       dev_i2c.i2c_read(&data[1], expdevaddr, GPDR_8_15, 1);			
       *(uint16_t*)data = *(uint16_t*)data | (1<<(uint16_t)exppinname);  // set gpio as out 			
       dev_i2c.i2c_write(data, expdevaddr, GPDR_0_7, 1);
       dev_i2c.i2c_write(&data[1], expdevaddr, GPDR_8_15, 1);			
       write(lvl);
    }         

		void write (int lvl) {
			uint8_t data[2];			
			/* set the exppinname state to lvl */
			dev_i2c.i2c_read(data, expdevaddr, GPSR_0_7, 2);
			*(uint16_t*)data = *(uint16_t*)data & (uint16_t)(~(1<<(uint16_t)exppinname));  // set pin mask 			
			if (lvl) *(uint16_t*)data = *(uint16_t*)data | (uint16_t)(1<<(uint16_t)exppinname);
			dev_i2c.i2c_write(data, expdevaddr, GPSR_0_7, 2);
		}
		
    STMPE1600DigiOut& operator=(int lvl)
    {
       write (lvl);
       return *this;
    }		
		
 private:
    DevI2C &dev_i2c; 
    uint8_t expdevaddr;
    ExpGpioPinName exppinname; 	
};

class STMPE1600DigiIn 
{	
 public: 
    STMPE1600DigiIn (DevI2C &i2c, ExpGpioPinName inpinname, uint8_t DevAddr=STMPE1600_DEF_DEVICE_ADDRESS*2): dev_i2c(i2c), expdevaddr(DevAddr), exppinname(inpinname) 
		{
			uint8_t data[2];
			/* set the exppinname as input pin direction */
			dev_i2c.i2c_read(data, expdevaddr, GPDR_0_7, 2);
			*(uint16_t*)data = *(uint16_t*)data & (uint16_t)(~(1<<(uint16_t)exppinname));  // set gpio as in			
			dev_i2c.i2c_write(data, expdevaddr, GPDR_0_7, 2);
		}         

		bool read () {
			uint8_t data[2];
			/* read the exppinname */
			dev_i2c.i2c_read(data, expdevaddr, GPMR_0_7, 2);
			*(uint16_t*)data = *(uint16_t*)data & (uint16_t)(1<<(uint16_t)exppinname);  // mask the in gpio
			if (data[0] || data[1]) return 1;
			return 0;
		}
		
    operator int() 
    {		
       return read();
    }		
		
 private:
    DevI2C &dev_i2c; 
    uint8_t expdevaddr;
    ExpGpioPinName exppinname;      
};


/*
class STMPE1600 {
	
 public: 
    STMPE1600 (DevI2C &i2c, 
											ExpGpioPinDirection GPDR0, ExpGpioPinDirection GPDR1, ExpGpioPinDirection GPDR2,
                      ExpGpioPinDirection GPDR3, ExpGpioPinDirection GPDR4, ExpGpioPinDirection GPDR5,
                      ExpGpioPinDirection GPDR6, ExpGpioPinDirection GPDR7, ExpGpioPinDirection GPDR8,
                      ExpGpioPinDirection GPDR9, ExpGpioPinDirection GPDR10, ExpGpioPinDirection GPDR11,
 ExpGpioPinDirection GPDR12, ExpGpioPinDirection GPDR13, ExpGpioPinDirection GPDR14, ExpGpioPinDirection GPDR15, uint8_t DevAddr=STMPE1600_DEF_DEVICE_ADDRESS ) :dev_i2c(i2c)

 { 
				dev_i2c = i2c;								
				expdevaddr = DevAddr;
			  GPDR0_15 = (uint16_t)0;	// gpio dir all IN
			  GPSR0_15 = (uint16_t)0x0ffff;  // gpio status all 1
				if (GPDR0  == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x0001;
				if (GPDR1  == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x0002;																		 
				if (GPDR2  == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x0004;
				if (GPDR3  == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x0008;																		 
				if (GPDR4  == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x0010;
				if (GPDR5  == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x0020;																		 
				if (GPDR6  == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x0040;
				if (GPDR7  == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x0080;
				if (GPDR8  == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x0100;
				if (GPDR9  == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x0200;
				if (GPDR10 == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x0400;
				if (GPDR11 == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x0800;																		 
				if (GPDR12 == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x1000;																		 
				if (GPDR13 == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x2000;																		 
				if (GPDR14 == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x4000;									
				if (GPDR15 == OUTPUT) GPDR0_15 = GPDR0_15 | (uint16_t)0x8000;	
				dev_i2c.i2c_write((uint8_t*)&GPDR0_15, expdevaddr, GPDR_0_7, 2);	
				dev_i2c.i2c_write((uint8_t*)&GPSR0_15, expdevaddr, GPSR_0_7, 2);	
		}
											
		void readGPSR0_15 (uint16_t * gpsr0_15){
			dev_i2c.i2c_read((uint8_t*)gpsr0_15, expdevaddr, GPSR_0_7, 2);
			GPSR0_15 = gpsr0_15;
		}

		void writeGPSR0_15 (uint16_t *gpsr0_15){
			dev_i2c.i2c_write((uint8_t*)*gpsr0_15, expdevaddr, GPSR_0_7, 2);	
			GPSR0_15 = *gpsr0_15;
		}
		
 private:
    DevI2C           &dev_i2c; 	 
		uint16_t 					GPDR0_15;
		uint16_t					GPSR0_15;
		uint8_t     		  expdevaddr;
 };
*/
#endif // __STMPE1600_CLASS
