/**
 ******************************************************************************
 * @file    vl6180x_class.h
 * @author  AST / EST
 * @version V0.0.1
 * @date    14-April-2015
 * @brief   Header file for component VL6180X
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/
#ifndef     __STMPE1600_CLASS
#define     __STMPE1600_CLASS
/* Includes ------------------------------------------------------------------*/
#include    "mbed.h"
#include		<assert.h>

#define STMPE1600_DEF_DEVICE_ADDRESS  (uint8_t)0x42*2   // in 7 bits I2C format
#define STMPE1600_DEF_DIGIOUT_LVL      0

/**  STMPE1600 registr map **/
#define VersionId			(uint8_t)0x02
#define SystemControl (uint8_t)0x03
#define IEGPIOR_0_7		(uint8_t)0x08
#define IEGPIOR_8_15	(uint8_t)0x09
#define ISGPIOR_0_7		(uint8_t)0x0A
#define ISGPIOR_8_15	(uint8_t)0x0B
#define GPMR_0_7			(uint8_t)0x10
#define GPMR_8_15			(uint8_t)0x11
#define GPSR_0_7			(uint8_t)0x12
#define GPSR_8_15			(uint8_t)0x13
#define GPDR_0_7			(uint8_t)0x14
#define GPDR_8_15			(uint8_t)0x15
#define GPIR_0_7			(uint8_t)0x16
#define GPIR_8_15			(uint8_t)0x17

  typedef enum {
    // GPIO Expander pin names
    GPIO_0,
    GPIO_1,
    GPIO_2,
    GPIO_3,            
    GPIO_4,
    GPIO_5,
    GPIO_6,
    GPIO_7,            
    GPIO_8,
    GPIO_9,
    GPIO_10,
    GPIO_11,            
    GPIO_12,
    GPIO_13,
    GPIO_14,
    GPIO_15
} ExpGpioPinName;   

typedef enum {
    INPUT,
    OUTPUT,
	  NOT_CONNECTED
}ExpGpioPinDirection;


class STMPE1600DigiOut {
	
 public: 
    STMPE1600DigiOut (DevI2C &i2c, ExpGpioPinName outpinname, uint8_t DevAddr=STMPE1600_DEF_DEVICE_ADDRESS, bool lvl=STMPE1600_DEF_DIGIOUT_LVL): dev_i2c(i2c), expdevaddr(DevAddr), exppinname(outpinname) 
		{
			uint8_t data[2];				
			/* set the exppinname as output */
			dev_i2c.i2c_read(data, expdevaddr, GPDR_0_7, 1);
			dev_i2c.i2c_read(&data[1], expdevaddr, GPDR_8_15, 1);			
			*(uint16_t*)data = *(uint16_t*)data | (1<<(uint16_t)exppinname);  // set gopio as out 			
			dev_i2c.i2c_write(data, expdevaddr, GPDR_0_7, 1);
			dev_i2c.i2c_write(&data[1], expdevaddr, GPDR_8_15, 1);			
			write(lvl);
			
		}         

		void write (int lvl) {
			uint8_t data[2];			
			/* set the exppinname state to lvl */
			dev_i2c.i2c_read(data, expdevaddr, GPSR_0_7, 1);
			dev_i2c.i2c_read(&data[1], expdevaddr, GPSR_8_15, 1);			
			*(uint16_t*)data = *(uint16_t*)data & (~(1<<(uint16_t)exppinname));  // set pin mask 			
			if (lvl) *(uint16_t*)data = *(uint16_t*)data | ( 1<<(uint16_t)exppinname);
			dev_i2c.i2c_write(data, expdevaddr, GPSR_0_7, 1);
			dev_i2c.i2c_write(&data[1], expdevaddr, GPSR_8_15, 1);			
		}
		
		STMPE1600DigiOut& operator=(int lvl) {
			write (lvl);
			return *this;
		}		
		
 private:
    DevI2C          &dev_i2c; 
    uint8_t     		expdevaddr;
    ExpGpioPinName 	exppinname; 	
};

class STMPE1600DigiIn {
	
 public: 
    STMPE1600DigiIn (DevI2C &i2c, ExpGpioPinName inpinname, uint8_t DevAddr=STMPE1600_DEF_DEVICE_ADDRESS): dev_i2c(i2c), expdevaddr(DevAddr), exppinname(inpinname) 
		{
			uint8_t data[2];
			/* set the exppinname as input pin direction */
			dev_i2c.i2c_read(data, expdevaddr, GPDR_0_7, 1);
			dev_i2c.i2c_read(&data[1], expdevaddr, GPDR_8_15, 1);			
			*(uint16_t*)data = *(uint16_t*)data & (~(1<<(uint16_t)exppinname));  // set gopio as in			
			dev_i2c.i2c_write(data, expdevaddr, GPDR_0_7, 1);
			dev_i2c.i2c_write(&data[1], expdevaddr, GPDR_8_15, 1);						
		}         

		bool read () {
			uint8_t data[2];
			/* read the exppinname */
			dev_i2c.i2c_read(data, expdevaddr, GPMR_0_7, 1);
			dev_i2c.i2c_read(&data[1], expdevaddr, GPMR_8_15, 1);			
			*(uint16_t*)data = *(uint16_t*)data & (1<<(uint16_t)exppinname);  // mask the in gpio
			if (data[0] || data[1]) return 1;
			return 0;
		}
		
		operator int() {		
			return read();
		}		
		
 private:
    DevI2C          &dev_i2c; 
    uint8_t     		expdevaddr;
    ExpGpioPinName 	exppinname;      
};


#endif // __STMPE1600_CLASS
