/**
 ******************************************************************************
 * @file    vl6180x_class.h
 * @author  AST / EST
 * @version V0.0.1
 * @date    14-April-2015
 * @brief   Header file for component VL6180X
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/

#ifndef __VL6180X_CLASS_H
#define __VL6180X_CLASS_H

/* Includes ------------------------------------------------------------------*/
#include "RangeSensor.h"
#include "LightSensor.h"
#include "DevI2C.h" //temporaneo fino alla creazione della classe x_nucleo_6180xa1
#include "vl6180x_api.h"
#include "vl6180x_cfg.h"
#include "vl6180x_def.h"
#include "vl6180x_types.h"
#include "vl6180x_platform.h"
#include "vl6180x_appcfg.h"
#include "STMPE1600_class.h"

/** default device address */
#define DEFAULT_DEVICE_ADDRESS		0x29

/* Classes -------------------------------------------------------------------*/
/** Class representing a VL6180X sensor component
 */
class VL6180X : public RangeSensor, public LightSensor 
{
 public:
    /** Constructor
     * @param[in] i2c device I2C to be used for communication
     * @param[in] digital out pin/STMPE1600DigiOut pin to be used for GPIO expander communication
     * @param[in] device address, 0x29 by default 
     * @param[in] device id, 0 by default
     */

		 
		 VL6180X(DevI2C &i2c, DigitalOut &pin, uint8_t DevAddr=DEFAULT_DEVICE_ADDRESS) : RangeSensor(), LightSensor(), dev_i2c(i2c), gpio0(&pin)
		 {
		    MyDeviceAddress=DevAddr;
        Present=0;
        Ready=0;
		 }  
		 
     VL6180X(DevI2C &i2c, STMPE1600DigiOut &pin, uint8_t DevAddr=DEFAULT_DEVICE_ADDRESS) : RangeSensor(), LightSensor(), dev_i2c(i2c), expgpio0(&pin)
		 {
		    MyDeviceAddress=DevAddr;
        Present=0;
        Ready=0;
		 }  
		 
    
   /** Destructor
    */
    //~VL6180X(){} 
		 
		 
		 void VL6180x_On(void) {
			if (gpio0) *gpio0=1;
			else if (expgpio0) *expgpio0=1;
		} 
		
    void VL6180x_Off(void) {
			if (gpio0) *gpio0=0;
			else if (expgpio0) *expgpio0=0;			
		}
		//Init sensor accende, legge id, inizializza il dispositivo e prepara per le misure (range, als)
    //altrimenti errore e cancello dalla board		
		
    /*** Interface Methods ***/
    /*virtual*/ int Init() 
    {
        return VL6180x_InitData(MyDeviceAddress); // ritorna 0 se corretto 
    }
    
    /*virtual*/ int ReadID() 
    {
        return VL6180X_ReadID(); // ritorna 0 se corretto e -2 se errore
    }
		/*

		void SetPresent()
		{
			  MyDevice.Present=1;
		}
		
		void SetDeviceID(int n)
		{
			  MyDevice.DevID=n;
		}
		
		void SetReady()
		{
			  MyDevice.Ready=1;
		}		
	   
    /*
    virtual int GetRange(int *piData) {
        return VL6180X_GetRange(piData);
    }

    virtual int GetLight(int *piData) {
        return VL6180X_GetLight(piData);
    }
    
		/* api.c functions */
		int VL6180x_WaitDeviceBooted(VL6180xDev_t dev);
		int VL6180x_InitData(VL6180xDev_t dev );
		int VL6180x_SetupGPIO1(VL6180xDev_t dev, uint8_t IntFunction, int ActiveHigh);
		int VL6180x_Prepare(VL6180xDev_t dev);
		int VL6180x_RangeStartContinuousMode(VL6180xDev_t dev);
		int VL6180x_RangeStartSingleShot(VL6180xDev_t dev);
		int VL6180x_RangeSetMaxConvergenceTime(VL6180xDev_t dev, uint8_t  MaxConTime_msec);
		int VL6180x_RangePollMeasurement(VL6180xDev_t dev, VL6180x_RangeData_t *pRangeData);
		int VL6180x_RangeGetMeasurementIfReady(VL6180xDev_t dev, VL6180x_RangeData_t *pRangeData);
		int VL6180x_RangeGetMeasurement(VL6180xDev_t dev, VL6180x_RangeData_t *pRangeData);
		int VL6180x_RangeGetResult(VL6180xDev_t dev, int32_t *pRange_mm);
		int VL6180x_RangeConfigInterrupt(VL6180xDev_t dev, uint8_t ConfigGpioInt);
		int VL6180x_RangeGetInterruptStatus(VL6180xDev_t dev, uint8_t *pIntStatus);
		int VL6180x_AlsPollMeasurement(VL6180xDev_t dev, VL6180x_AlsData_t *pAlsData);
		int VL6180x_AlsGetMeasurement(VL6180xDev_t dev, VL6180x_AlsData_t *pAlsData);
		int VL6180x_AlsConfigInterrupt(VL6180xDev_t dev, uint8_t ConfigGpioInt);
		int VL6180x_AlsSetIntegrationPeriod(VL6180xDev_t dev, uint16_t period_ms);
		int VL6180x_AlsSetInterMeasurementPeriod(VL6180xDev_t dev,  uint16_t intermeasurement_period_ms);
		int VL6180x_AlsSetAnalogueGain(VL6180xDev_t dev, uint8_t gain);
		int VL6180x_AlsSetThresholds(VL6180xDev_t dev, uint8_t low, uint8_t high);
		int VL6180x_AlsGetInterruptStatus(VL6180xDev_t dev, uint8_t *pIntStatus);
		int VL6180x_StaticInit(VL6180xDev_t dev);
		int VL6180x_RangeWaitDeviceReady(VL6180xDev_t dev, int MaxLoop );
		int VL6180x_RangeSetInterMeasPeriod(VL6180xDev_t dev, uint32_t  InterMeasTime_msec);
		int VL6180x_UpscaleSetScaling(VL6180xDev_t dev, uint8_t scaling);
		int VL6180x_UpscaleGetScaling(VL6180xDev_t dev);
		uint16_t VL6180x_GetUpperLimit(VL6180xDev_t dev);
		int VL6180x_RangeSetThresholds(VL6180xDev_t dev, uint16_t low, uint16_t high, int SafeHold);
		int VL6180x_RangeGetThresholds(VL6180xDev_t dev, uint16_t *low, uint16_t *high);
		int VL6180x_RangeSetRawThresholds(VL6180xDev_t dev, uint8_t low, uint8_t high);
		int VL6180x_RangeSetEceFactor(VL6180xDev_t dev, uint16_t  FactorM, uint16_t FactorD);
		int VL6180x_RangeSetEceState(VL6180xDev_t dev, int enable );
		int VL6180x_FilterSetState(VL6180xDev_t dev, int state);
		int VL6180x_FilterGetState(VL6180xDev_t dev);
		int VL6180x_DMaxSetState(VL6180xDev_t dev, int state);
		int VL6180x_DMaxGetState(VL6180xDev_t dev);
		int VL6180x_RangeSetSystemMode(VL6180xDev_t dev, uint8_t mode);
		int8_t VL6180x_GetOffsetCalibrationData(VL6180xDev_t dev);
		void VL6180x_SetOffsetCalibrationData(VL6180xDev_t dev, int8_t offset);
		int VL6180x_SetXTalkCompensationRate(VL6180xDev_t dev, FixPoint97_t Rate);
		int VL6180x_AlsWaitDeviceReady(VL6180xDev_t dev, int MaxLoop );
		int VL6180x_AlsSetSystemMode(VL6180xDev_t dev, uint8_t mode); 
		int VL6180x_SetGroupParamHold(VL6180xDev_t dev, int Hold);
		int VL6180x_SetI2CAddress(VL6180xDev_t dev, uint8_t NewAddr);
		int VL6180x_SetupGPIOx(VL6180xDev_t dev, int pin, uint8_t IntFunction, int ActiveHigh);
		int VL6180x_SetGPIOxPolarity(VL6180xDev_t dev, int pin, int active_high);
		int VL6180x_SetGPIOxFunctionality(VL6180xDev_t dev, int pin, uint8_t functionality);
		int VL6180x_DisableGPIOxOut(VL6180xDev_t dev, int pin);
		int VL6180x_GetInterruptStatus(VL6180xDev_t dev, uint8_t *status);
		int VL6180x_ClearInterrupt(VL6180xDev_t dev, uint8_t IntClear );
		int VL6180x_RangeStaticInit(VL6180xDev_t dev); 
		int VL6180x_UpscaleRegInit(VL6180xDev_t dev);
		int VL6180x_UpscaleStaticInit(VL6180xDev_t dev); 
		int VL6180x_AlsGetLux(VL6180xDev_t dev, lux_t *pLux);
		int _UpscaleInitPatch0(VL6180xDev_t dev); 
		int VL6180x_RangeGetDeviceReady(VL6180xDev_t dev, int * Ready);
		int VL6180x_RangeSetEarlyConvergenceEestimateThreshold(VL6180xDev_t dev);
		int32_t _GetAveTotalTime(VL6180xDev_t dev); 
		int32_t _filter_Start(VL6180xDev_t dev, uint16_t m_trueRange_mm, uint16_t m_rawRange_mm, uint32_t m_rtnSignalRate, uint32_t m_rtnAmbientRate, uint16_t errorCode);
		int _filter_GetResult(VL6180xDev_t dev, VL6180x_RangeData_t *pRangeData);
		int _GetRateResult(VL6180xDev_t dev, VL6180x_RangeData_t *pRangeData); 
		int _DMax_InitData(VL6180xDev_t dev);
		
    /* Read functions from registers and write functions into registers  */
    int VL6180X_ReadID();
    int VL6180X_IO_Read(uint8_t *pBuffer, uint8_t RegisterAddress, uint16_t NumByteToRead);
    
    /* Write and read functions from I2C */
    int VL6180x_WrByte(VL6180xDev_t dev, uint16_t index, uint8_t data);
    int VL6180x_WrWord(VL6180xDev_t dev, uint16_t index, uint16_t data);
    int VL6180x_WrDWord(VL6180xDev_t dev, uint16_t index, uint32_t data);
    int VL6180x_RdByte(VL6180xDev_t dev, uint16_t index, uint8_t *data);
    int VL6180x_RdWord(VL6180xDev_t dev, uint16_t index, uint16_t *data);
    int VL6180x_RdDWord(VL6180xDev_t dev, uint16_t index, uint32_t *data);
		int VL6180x_UpdateByte(VL6180xDev_t dev, uint16_t index, uint8_t AndData, uint8_t OrData);
    int VL6180x_I2CWrite(uint8_t DeviceAddr, uint16_t RegisterAddr, uint8_t *pBuffer, uint16_t NumByteToWrite);
    int VL6180x_I2CRead(uint8_t DeviceAddr, uint16_t RegisterAddr, uint8_t *pBuffer, uint16_t NumByteToRead);
		

private:
    /*** Instance Variables ***/
    /* IO Device */
    DevI2C &dev_i2c;
    DigitalOut *gpio0;
    STMPE1600DigiOut *expgpio0;  
    
    VL6180xDev_t MyDeviceAddress;
    unsigned Present;
    unsigned Ready;
    
};

#endif // __VL6180X_CLASS_H
