#include "include.h"
///# include

//GPIO define
BusOut adress(A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,A12,A13,A14,A15);
BusInOut data(D0,D1,D2,D3,D4,D5,D6,D7);

//Serial device
Serial keyboard(Tx_KB,Rx_KB);// Tx, Rx

//SPI device
VS1053 mp3(MOSI_AUDIO, MISO_AUDIO, CLK_AUDIO, CS_AUDIO, RST_AUDIO,DREQ_AUDIO,DSC_AUDIO,PA_4);
//RA8875 lcd(MOSI_LCD, MISO_LCD, CLK_LCD, CS_LCD, NC, "tft");
SDBlockDevice sd(MOSI_SD, MISO_SD, CLK_SD, CS_SD);

//File system
FATFileSystem fs("fs");

//Tread
Thread kb_thread;

//lcd methods
void init_lcd();
void print(char data[59]);
void print_int(int a);
void print_double(double a);
void backspace();
void lcd_cls();
void set_backlight(float back);

//keyboard thread
void keyboard_task()
{
    while(true) {
        input[position] = keyboard.getc();
    }
}

int main()
{
    wait(0.3);
    //init device
    init_lcd();
    mp3.initialize();
    keyboard.baud(57600);
    
    kb_thread.start(keyboard_task);
    sd.init();
    fs.mount(&sd);
    print("HagridOS v.5.0\n>");

    ///start main code
    while (true) {

        if(!keyboard.readable()) { //scan key
            if(input[position]=='Q') {//press backspace
                backspace();
                input[position] = '\0';
                position-=1;
            } else {

                if (input[position] == '\n') { //press enter
                    input[position] = '\0'; //insert in end position NULL character
                    kbsplit(input);//split keyboard input

                    if(tmpE[0] == NULL) { //press only enter if
                        print("\n>");
                    } else {
                        switch(compare(&tmpE[0])) { //switch run basic commands
                            case 0://mkdir
                                fs.mkdir(tmpE[1],777);
                                print("\n>");
                                erase();
                                break;
                            case 1://remove
                                fs.remove(tmpE[1]);
                                print("\n>");
                                erase();
                                break;
                            case 2://ls
                                fs.mount(&sd);
                                DIR *d;
                                struct dirent *p;
                                d = opendir(adir);
                                if (d != NULL) {
                                    while ((p = readdir(d)) != NULL) {
                                        print("\n");
                                        print(p->d_name);
                                    }
                                }
                                closedir(d);
                                fs.unmount();
                                print("\n>");
                                erase();
                                break;
                            case 3://cls
                                lcd_cls();
                                print("HagridOS v.5.0\n>");
                                erase();
                                break;
                            case 4://info
                                print("\nBasic Operation System for STM32 by HAGRID\n");
                                print("Version: 5.0 release: 10.03.2018\n");
                                //lcd.printf("SD size: %lluMb\n\r",(sd.size()/1024)/1024);
                                print("CPU speed: ");
                                print_double(SystemCoreClock/1000000);
                                print(" MHz");
                                print("\n>");
                                erase();
                                break;
                            case 5://edit
                                print("\n>");
                                erase();
                                break;
                            case 6://sleep
                                wait(atoi(tmpE[1]));
                                print("\n>");
                                erase();
                                break;
                            case  7://GPIO
                                if(!strcasecmp("data",tmpE[1])) {
                                    if(tmpE[2]==NULL) {
                                        data.input();
                                        print("\n");
                                        int in = data.read();
                                        print_int(in);
                                    } else {
                                        data.output();
                                        data = atoi(tmpE[2]);
                                    }
                                }
                                if(!strcasecmp("adress",tmpE[1])) {
                                    adress = atoi(tmpE[2]);
                                }
                                print("\n>");
                                erase();
                                break;
                            case 8://backlight
                                set_backlight(atof(tmpE[1]));
                                print("\n>");
                                erase();
                                break;
                            case 9://play
                                sprintf(apath,"%s%s",apath,tmpE[1]);
                                FILE* song = fopen(apath, "r");

                                while(!feof(song)) {
                                    int n=fread(&array, 1, sizeof(array), song);
                                    mp3.writeStream(array,n);
                                }
                                mp3.terminateStream();

                                fclose(song);  //close the file
                                print("\n>");
                                erase();
                                break;
                            case 10://cd
                                sprintf(adir,"%s%s",adir,tmpE[1]);
                                print("\n>");
                                erase();
                                break;
                            case 11://help
                                print("\n");
                                print("mkdir file_name         rm file_name\n");
                                print("ls                      cls\n");
                                print("info                    edit file_name\n");
                                print("sleep time              gpio mode dec_value\n");
                                print("backlight value         play file_name\n");
                                print("cd folder_name          help\n");
                                print("out data/adress value   ");
                                print("\n>");
                                erase();
                                break;
                            default://command not found
                                print("\n");
                                print("hsh: ");
                                print(tmpE[0]);
                                print(" command not found");
                                print("\n>");
                                erase();
                                break;
                        }//end switch
                    }//end press enter only
                } else {
                    print(&(input[position]));
                    position++;
                }//end press enter
            }//end press backspace
        }//end press key
        wait(0.1);
    }//end while
    fs.unmount();
}//end main