#include "mbed.h"
#include "RA8875.h"
#include "pinout.h"

RA8875 lcd_m(MOSI_LCD, MISO_LCD, CLK_LCD, CS_LCD, NC, "tft");

int x;
int y;


void init_lcd()
{
    lcd_m.init(480,272);
    lcd_m.foreground(Orange);
}

void print(char data[59])
{
    int len = strlen(data);
    for(int i =0; i<len; i++) {
        lcd_m.SetTextCursor(x,y);
        lcd_m.putc(data[i]);
        x+=8;
        if(data[i] == '\n') {
            x=0;
            y+=17;
        }
    }
}

void print_int(int a)
{
    char tmp[20];//max 20 digit number
    sprintf(tmp,"%i",a);
    print(tmp);
}

void print_double(double a)
{
    char tmp[20];//max 20 digit number
    sprintf(tmp,"%f",a);
    print(tmp);
}


void backspace()
{
    x-=8;
    lcd_m.SetTextCursor(x,y);
    lcd_m.putc(NULL);
}

void lcd_cls()
{
    lcd_m.cls();
    x=0;
    y=0;
}

void set_backlight(float back)
{

    lcd_m.Backlight(back);
}



