#include "mbed.h"
#include "BMP085.h"

BMP085 bmp085(p28, p27,BMP085_oss8);

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

int main() {
    while(1) {
        myled = 1;

        bmp085.update();
        float altitude=bmp085.calcAltitude(bmp085.get_pressure()*100);
        pc.printf("p:%f hPa / t:%f / altitude=%f \n\r",bmp085.get_pressure() , bmp085.get_temperature(),altitude);

        myled = 0;
        wait(3);
    }
}
