#ifndef __GWOOPS_GPS_H_
#define __GWOOPS_GPS_H_

#include "mbed.h"

#define TIMEMAX     6
#define LATMAX      20
#define LONGMAX     20
#define SPEEDMAX    6
#define TRACKMAX    6
#define DATEMAX     6
#define MAGVARMAX   6
#define CHECKSUMMAX 10
#define DEVNULMAX   20
#define GPSBUFFSIZE 256


typedef struct {
    char time[TIMEMAX+1];
    char status;
    char latitude[LATMAX+1];
    double dlatitude;
    char latdir;
    char longitude[LONGMAX+1];
    double dlongitude;
    char longdir;
    char speed[SPEEDMAX+1];
    char trackangle[TRACKMAX+1];
    char date[DATEMAX+1];
    char magvar[MAGVARMAX+1];
    char magvardir;
} GPRMCSentence;

class GwoopsGPS {
    
    private:
    
        Serial *gps;
        char * rawgpsdata;
        unsigned rawindex;
        char time[TIMEMAX+1];
        char status;
        char latitude[LATMAX+1];
        double dlatitude;
        char latdir;
        char longitude[LONGMAX+1];
        double dlongitude;
        char longdir;
        char speed[SPEEDMAX+1];
        char trackangle[TRACKMAX+1];
        char date[DATEMAX+1];
        char magvar[MAGVARMAX+1];
        char magvardir;
        uint8_t valid;
        
    public:
    
        /**************************************************************************
        * CONSTRUCTORS & DESTRUCTOR
        *************************************************************************/
        GwoopsGPS(Serial*);  //PinName _tx, PinName _rx, int _baudrate);
        ~GwoopsGPS();
        
        /**************************************************************************
        * GETTERS
        *************************************************************************/
        char* getrawgpsdata();
        //int getbaudrate();
        char* gettime();
        char getstatus();
        char* getlatitude();
        double getdlatitude();
        char getlatdir();
        char* getlongitude();
        double getdlongitude();
        char getlondir();
        char* getspeed();
        char* gettrackangle();
        char* getdate();
        char* getmagvar();
        char getmagvardir();
        uint8_t  isValid(); 
        
        /**************************************************************************
        * MEMBER FUNCTIONS
        *************************************************************************/
        void init();
        void deinit();
        void clearRawGPSData();
        void clearAllData();
        int8_t parseRawGPSData(char*, GPRMCSentence*);
        void printData(Serial*);
        void parseCallback();
        void writeStructToObj(GPRMCSentence*);
    
        
}; /* End GwoopsGPS */
#endif