#include "mbed.h"
#include "GPRMCSentence.h"

#define GPSBUFFSIZE 256

Serial pc(USBTX, USBRX); // tx, rx
Serial xgps(PTC15, PTC14);
// If using MODSERIAL (as part of the WNC Interface for the AT&T IoT Starter Kit):
// MODSERIAL xgps(PTC15, PTC14, GPSBUFFSIZE, GPSBUFFSIZE);

unsigned gpsSentenceIndex = 0;
char gpsSentence[GPSBUFFSIZE];
GPRMCSentence lastPosition;

void clearGpsSentence() {
    for(int i=0;i<GPSBUFFSIZE;i++) gpsSentence[i] = '\0';
    gpsSentenceIndex = 0;
}
 
int main() {
    pc.printf("Where am I? ----------- \n");
    clearGpsSentence();
    while(1) {
        gpsSentence[gpsSentenceIndex] = xgps.getc();
        //pc.putc(gpsSentence[gpsSentenceIndex]);
        gpsSentenceIndex++;
        if(gpsSentence[gpsSentenceIndex - 1] == '\n') {
            gpsSentence[gpsSentenceIndex] = '\0';
            if (parseGPRMCStrToStruct(gpsSentence, &lastPosition) >= 0) {
                pc.printf("time: %s Status: %c \n\r" , lastPosition.time, lastPosition.status);
                pc.printf("Lat : %s %c \n\r" , lastPosition.latitude, lastPosition.latdir);
                pc.printf("Long: %s %c \n\r" , lastPosition.longitude, lastPosition.longdir);
            }
            clearGpsSentence();
        }
    }
}


/*include "mbed.h"

DigitalOut rled(LED_RED);
DigitalOut gled(LED_GREEN);
DigitalOut bled(LED_BLUE);

int main() {
    while(1) {
        rled = 0;
        gled = 0;
        bled = 0;
        wait(0.2);
        rled = 0;
        gled = 0;
        bled = 1;
        wait(0.2);
        rled = 0;
        gled = 1;
        bled = 0;
        wait(0.2);
        rled = 0;
        gled = 1;
        bled = 1;
        wait(0.2);
        rled = 1;
        gled = 0;
        bled = 0;
        wait(0.2);
        rled = 1;
        gled = 0;
        bled = 1;
        wait(0.2);
        rled = 1;
        gled = 1;
        bled = 0;
        wait(0.2);
        rled = 1;
        gled = 1;
        bled = 1;
        wait(0.2);
    }
}*/
