//////////////////////////////////////////////////////////////////////////
//  MBED AE-LPC11U35 Small Dose Measure  Program  1CH入力　/　Range固定   //
//      SingleCH Dose CH0:AD7 P14=P0_23 , RNG P19=P0_1                  //
//                   // CH1:AD6 P07=P0_22 , RNG P23=P0_2  （Dummy)              //
//            Since 2018.02.14  H.Tsunemoto                             //
//  for ADC Measurement Timer(0.1mSec)Interrupt                         //
//   Sample Time 1.0msec - 1000msec                                     //
//   Since 2016.05.18  H.Tsunemoto                                      //
//   Sample Program Import (1) Serial_interrupt: LPC11U68_USBserial     //
//                         (2) Timer_Interrupt: LPC1114_ticker          //
//                         (3) Internal_ADC_with_interrupt              //
/////////////////////////////////////////////////////////////////////
#include "mbed.h"
#include "LPC11Uxx.h"
#include "USBSerial.h"
#include "stdio.h"
#include "math.h"

//-------------------------------------//
// --- MBED I/O Asign  declaration --- //
//-------------------------------------//
//Virtual serial port over USB
USBSerial serial;
//Serial pc(USBTX, USBRX);
//Serial device(P0_3,P0_1);
Serial device(P0_19,P0_18);

// ADC Port Asign P14: ad_ch1(AD7)  P7 = ad7
AnalogIn ad_ch1(P0_23); // AD CH1 P14 MBED ADC Input
//AnalogIn ad_ch1(P0_22); // AD CH2 P7  MBED ADC Input Dummy

DigitalOut led1(P0_7);  //P3 = P0_7 LED1); Dummy 
DigitalOut led2(P0_8);  //P4 = P0_8 LED2);
DigitalOut led3(P0_9);  //P5 = P0_9 LED3);
DigitalOut led4(P0_10); //P6 = P0_10       // LED 4 Dummy 


//DigitalOut POut_CH1_Rng(P0_1);   // Pout CH1 Range Select No Control
//DigitalOut POut_CH2_Rng(P0_2);   // Pout CH2 Range Select No Control
// Debug Led ON/Off
#define Debug_LED_Active 1
#define Debug_LED_Disable 0
int i_LED_Active = Debug_LED_Active;
//---------------------------------------------------------//
//   <<< ADC Sample Parameter & Function declaration >>>   //
//---------------------------------------------------------//
//----  ADC Interrupt Timer -----//
int main_loop_count = 0;
Ticker ADC_Timer;
Timer t;
int ADC_Count1=0;
int ADC_Count1Block=0;
#define ADC_CH1 0
//#define ADC_CH2 1
volatile unsigned short Adc_inp_temp[2];
volatile unsigned long adc_CH1_Inp;
//volatile unsigned long adc_CH2_Inp;
// Ative Mode Status Controll
#define ActiveMode_ADC_Sample_Stop 0
#define ActiveMode_ADC_Sample_Busy  1  //
int i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Stop;
volatile int i_adc_Sample_Total_Count = 0;
volatile int i_adc_Sample_Total_Time = 0;
#define ADC_SAMPLE_AVE_MAX 4
volatile int adc_Sample_Ave_Count = 4;
#define ADC_SAMPLE_Empty 0
#define ADC_SAMPLE_Conplete 1
volatile int i_adc_Sample_Status = ADC_SAMPLE_Empty;
typedef struct st_adc_ave{
    
    volatile unsigned long sample_Add;
    volatile unsigned long sample_Ave;
}ST_ADC_AVE;
volatile ST_ADC_AVE st_adc_sample_ave[2];
const ST_ADC_AVE const_ADC_AVE_Default=
{
    0           //unsigned short sample_Add;
};
#define ADC_SAMPLE_RATE_MIN  1
#define ADC_SAMPLE_RATE_MAX  1000

//-------- ADC Measure Mode Parameter declaration  --------//
typedef struct  st_adc_param{
    int   i_sample_interval; // DAC Output Pattern
    int   i_CH1_Range;
    int   i_CH2_Range;
 }ST_ADC_PARAM;

ST_ADC_PARAM st_adc_mode_param;

//-------- ADC Measure Mode Parameter Default Set  --------//
const ST_ADC_PARAM const_ADC_Param_Default=
{
        1000       //i_sample_int=1000 microS
        ,0
        ,0
 };
//int adc_sample_interval = 1000;  // ADC Sample Rate 5 - 20000(20.0mSec)
void ADC_ave_Init();
void Start_ADC();
int ADC_Inp2CH();
void Tick_100usec_ADC_Interrupt();
//void ADC_Stop();      // 2018.02.19 for 100μsec Timer 2=>1 共通化
                        // STOP時は　ADC入力のみ停止
void ad_sample_send();
void adc_param_init();





//--------------------------------//
// --- Serial Communication  ---  //
//--------------------------------//
//void Tx_interrupt();
//void Rx_interrupt();
//void send_line();
int read_line();  // Return Rec CHAR Count 2013.08.08 Tsunemoto Append
void Rx_1char();



//---------- H.Tsunemoto Scince 2013.08.08  ---------// 
//-----------------------------------------------------------//
//--------- Timer Innterrupt For DAC Control  ---------------//
//-----------------------------------------------------------//
int timer_count=0;
int timer_1Sec=0;

//void TIMER0_IRQHandler(void);
//void timer0_init(void);
//---------  New Append Function  ---------//

void Ser_Command_Input();
//////////////////////////////////////////////////////////////////////////////////
//------------    Command Check & Set Function ---------------------------------//
// ADC No.1 "SMP 1000"  ADC Sample Rate 2 - 1000 msec
bool com_Check_SMP(int i_RecCharCount);
// ADC No.2 "RNA 0" ADC CH1 Range  0 / 1
bool com_Check_RNA(int i_RecCharCount);
// ADC No.3 "RNB 1" ADC CH2 Range  0 / 1
bool com_Check_RNB(int i_RecCharCount);
// ADC No.4 "START" ADC Sample Start
bool com_Check_START(int i_RecCharCount);
// ADC No.5 "STOP" ADC Sample Stop
bool com_Check_STOP(int i_RecCharCount);
// ADC No.6     // "STAT?"
void com_ADC_Table_Param_Send();  
// ADC No.7     // "LED0" LED Ena
bool com_Check_LED(int i_RecCharCount);  
//----------------------------------------------------------------//

// Circular buffers for serial TX and RX data - used by interrupt routines
const int ser_buffer_size = 255;
// might need to increase buffer size for high baud rates
char tx_buffer[ser_buffer_size];
char rx_buffer[ser_buffer_size];
// Circular buffer pointers
// volatile makes read-modify-write atomic
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
// Line buffers for sprintf and sscanf
char tx_line[80];
char rx_line[80];
//---  2013.08.08 Tsunemoto ------//
//--  rx Data Cr Rec Counter
volatile int rx_cr_Rec = 0;
//--------------------------------//

// 2016.06.21 Test Thresh Up
//volatile int debug_Count_Over = 0;
// ---------------------------------------------------------------//
//


/////////////////////////////////////////////////////////////////
//              <<<<  Main Function  >>>>                      //
/////////////////////////////////////////////////////////////////
// ---------------------------------------------------------------// 
// main test program
int main() {
    // Serial Speed Set 
    device.baud(115200);
//    serial.serial_baud(device,115200);
//serial.serial_baud(115200);

    timer_count = 0;
  ADC_Timer.attach_us(&Tick_100usec_ADC_Interrupt, (100));
 
//--- ADC Measurement Control Parameter Initial Set ---//
    adc_param_init(); 
// -- Main Loop -- //
 
    while (1) {
            if(i_LED_Active == Debug_LED_Active){
                 led3 = (led3+1) & 1;
            }
            if (i_adc_ActiveMode_status != ActiveMode_ADC_Sample_Stop){
            
                ad_sample_send();// --- ADC Sample & Serial Data Out  ---  //
            }
            if(rx_cr_Rec != 0){
                Ser_Command_Input();
            }
             /////////////////////////////////
      }
}

//////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------//
//-------     A/D Input & Data Send(Serial)                              -------//
//------------------------------------------------------------------------------//
// int ADC_Count1=0;                                                            //
// int ADC_Count1Block=0;                                                       //
/// #define ADC_CH1 0                                                            //
// #define ADC_CH2 1                                                            //
// unsigned short Adc_buff[3][ADC_BUFF_SIZE]                                     //
// int adc_buff_inp = 0;                                                        //
// int adc_buff_out = 0;                                                        //
//
//#define ActiveMode_ADC_Sample_Stop 0
//#define ActiveMode_ADC_Sample_Ready 1  // 
//#define ActiveMode_ADC_Sample_Busy  2  //
//int i_adc_ActiveMode_status ;
//                                                                              //
//#define ADC_TRIGGER_START_ENABLE
//#define ADC_TRIGGER__START_READY
//bool b_Trigger_Start_sendFlag = ADC_TRIGGER__START_READY;
//#define ADC_PULSE_END_ENABLE
//#define ADC_PULSE_END_READY
//bool b_Trigger_EndFlag = ADC_PULSE_END_READY;
//int i_adc_Waveform_count=0
//int i_adc_Sample_Total_Count = 0;
//int i_adc_Sample_Total_Time = 0;
//
//////////////////////////////////////////////////////////////////////////////////
void ad_sample_send(){
//float f_num;
   // A/D  CH1(P19) / CH2(P20)   => HEX SHORT 
    if(i_adc_ActiveMode_status == ActiveMode_ADC_Sample_Busy){
        if(i_adc_Sample_Status != ADC_SAMPLE_Empty){
           if(i_LED_Active == Debug_LED_Active){
                led4 = (led4+1) & 1;
            }
                if(st_adc_mode_param.i_sample_interval ==0){
                    st_adc_mode_param.i_sample_interval =1;
                    }
    // 2018.02.19 for Small Dose Special Range = 0 Dummy & Duplicate 0CH Data Send
               sprintf(tx_line,"%1d,%03x,%1d,%03x\r\n"
 //                serial.printf("%1d,%03x,%1d,%03x\r\n"
                        ,0
                        ,(st_adc_sample_ave[0].sample_Ave / st_adc_mode_param.i_sample_interval)
                        ,0
                        ,(st_adc_sample_ave[0].sample_Ave / st_adc_mode_param.i_sample_interval)
                        );
 /*
                serial.printf("%1d,%03x,%1d,%03x\r\n"
                        ,st_adc_mode_param.i_CH1_Range
                        ,(st_adc_sample_ave[0].sample_Ave / st_adc_mode_param.i_sample_interval)
                        ,st_adc_mode_param.i_CH2_Range
                        ,(st_adc_sample_ave[1].sample_Ave / st_adc_mode_param.i_sample_interval)
                        );
*/
                i_adc_Sample_Status =   ADC_SAMPLE_Empty;   
 //                send_line();
  //                  serial.Write(tx_line);
                if(i_LED_Active == Debug_LED_Active){
                    led4 = (led4+1) & 1;
                    led4 = (led4+1) & 1;
                }
 
       }
 //           led4 = 0;
    }
}

void Start_ADC() {
    ADC_Count1Block=0;
    ADC_Count1=0;

    t.reset();
//    t.start();
    //memset(Samples, 0, AANTAL_SAMPLES);
    //ADC_Timer.attach_us(&ADC_Interrupt, 200);
    // 2013_0827 Tsunemoto for 1/4Sample Average
 //   ADC_Timer.attach_us(&ADC_Interrupt, (st_adc_mode_param.i_sample_interval>>2));
//   ADC_Timer.attach_us(&Tick_100usec_ADC_Interrupt, (100));
    ADC_ave_Init();
    //ADC_Timer.attach_us(&ADC_Interrupt, st_adc_mode_param.i_sample_interval);
//    i_adc_Waveform_count = 0;
    t.start();
 //    led1 = 1;

 //   wait(0.0005);
 // 2016.06.21 Test Thresh Over Count
 //    debug_Count_Over = 0;
}
//*********************************************
//**    ADC 1/4 Sample Parameter init  **
//** 2013.08.27 Tsunemoto              **
//typedef struct st_adc_ave{
//    unsigned short sample_Add;
//    unsigned short sample_Max;
//    unsigned short sample_Min;
//}ST_ADC_AVE;
//ST_ADC_AVE st_adc_sample_ave[3];
//const ST_ADC_AVE const_ADC_AVE_Default=
//#define ADC_SAMPLE_AVE_MAX 4
//int adc_Sample_Ave_Count = 4;
//*************************************** 
void ADC_ave_Init()
{
  //  int i;
//    for (i=ADC_CH1;i<=ADC_CH2;i++){
        st_adc_sample_ave[0].sample_Add = const_ADC_AVE_Default.sample_Add;
 //       st_adc_sample_ave[i].sample_Max = const_ADC_AVE_Default.sample_Max;
 //       st_adc_sample_ave[i].sample_Min = const_ADC_AVE_Default.sample_Min;
//    }
    adc_Sample_Ave_Count = 0;
}
//****************************************************
//** ADC Sample Input for 1/4 Ave & MAX/Min Cansel  **
//Adc_inp_temp
// return ;0= No Buffer inc
//         1= Buffer Inp & Count INC
//****************************************************
int ADC_Inp2CH()
{
int i_ret=0;
        Adc_inp_temp[ADC_CH1] = ((ad_ch1.read_u16()>>4)&0xFFF);
  //      Adc_inp_temp[ADC_CH2] = ((ad_ch2.read_u16()>>4)&0xFFF);
        adc_Sample_Ave_Count++;
        // CH1 Ave 
        st_adc_sample_ave[ADC_CH1].sample_Add = st_adc_sample_ave[ADC_CH1].sample_Add + (unsigned long)Adc_inp_temp[ADC_CH1];
         // CH2 Ave 
 //       st_adc_sample_ave[ADC_CH2].sample_Add = st_adc_sample_ave[ADC_CH2].sample_Add + (unsigned long)Adc_inp_temp[ADC_CH2];
        
        if(adc_Sample_Ave_Count >= (st_adc_mode_param.i_sample_interval)){

            st_adc_sample_ave[ADC_CH1].sample_Ave = st_adc_sample_ave[ADC_CH1].sample_Add;
 //           st_adc_sample_ave[ADC_CH2].sample_Ave = st_adc_sample_ave[ADC_CH2].sample_Add;
            ADC_ave_Init();
            i_adc_Sample_Status = ADC_SAMPLE_Conplete;
            adc_Sample_Ave_Count = 0;
            i_ret = 1;
        }
        return(i_ret);
}
void Tick_100usec_ADC_Interrupt() {
     int i_inp_ret;
/////////////////////////////////////////////////
//2018.02.19  100μsec　Interval　Timer IRQ Common Control
//void cyclic(void)
// {
   if( i_LED_Active == Debug_LED_Active){
       led1=1;
    }
    Rx_1char();
    timer_count++;                  //increment timer_count
    if(timer_count >= 10000){
        timer_count = 0;
        timer_1Sec++;
    }
        i_adc_Sample_Total_Time++;
   if( i_LED_Active == Debug_LED_Active){
       led1=0;
    }
//}

///////////////////////////////////////////////////////////////////////
     if(i_LED_Active == Debug_LED_Active){
        led2 = 1;
      }
        ADC_Count1Block++;
    ADC_Count1++;
    if(i_adc_ActiveMode_status == ActiveMode_ADC_Sample_Busy){      
            i_inp_ret = ADC_Inp2CH();
    }
    else if (i_adc_ActiveMode_status == ActiveMode_ADC_Sample_Stop){
    }
    if(i_LED_Active == Debug_LED_Active){
        led2 = 0;
    }

}
//-------------------------------------------------------//
//    ADC Measurement Parameter Initial Set                          //
// 2013.08.14 H.Tsunemoto
//typedef struct  st_adc_param{
//    int   i_sample_interval; // DAC Output Pattern
//    float f_trigger_level;
//    unsigned short us_trigger_level;    // (3.3f/1023) * f_trigger_level (Image)
//    int i_pre_trig_point;
//    int i_pulse_end_time;
//}ST_ADC_PARAM;
//
//ST_ADC_PARAM st_adc_mode_param;
//-------------------------------------------------------//
void adc_param_init()
{
    st_adc_mode_param.i_sample_interval = const_ADC_Param_Default.i_sample_interval;
}
///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------//
//-----    Serial rx Commmand Input & Parameter Set Function   -----//
//  Tsunemoto Since 2016.05.20                                     //
// ADC No.1 "SMP 1000"  ADC Sample Rate 2 - 1000 msec
// ADC No.2 "RNA 0" ADC CH1 Range  0 / 1
// ADC No.3 "RNB 1" ADC CH2 Range  0 / 1
// ADC No.4 "START" ADC Sample Start
// ADC No.5 "STOP" ADC Sample Stop
// ADC No.6     // "?"

//------------------------------------------------------------------//
void Ser_Command_Input()
{
    int i_RecCharCount;
    bool b_CommadERR = 0;

    while(rx_cr_Rec != 0){
         // Read a line from the large rx buffer from rx interrupt routine
                 
        if(rx_in != rx_out){   
           i_RecCharCount = read_line();
           if(i_RecCharCount != 0){
                switch(rx_line[0]){
                    // Header "A"  ADC Control Command
                    case 'S':
                        if(i_RecCharCount == 1){
                                    i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Busy;
                                    Start_ADC();
                       }
                        else if (rx_line[1] == 'T'){
                            //case 'T':
                                if((rx_line[2] == 'A') && (rx_line[3] == 'R') && (rx_line[4] == 'T')){
                                    i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Busy;
                                    Start_ADC();
 
                                }
                                else if((rx_line[2] == 'O') && (rx_line[3] == 'P') ){
                                    i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Stop;
 // 2018.02.19 for 100μsec　Int　Timer Continuas　Enable 
///                                   ADC_Stop();
                                }
                                else if ((rx_line[2] == '?')){    //{    "ST?"
                                    com_ADC_Table_Param_Send();
                                }
                                else if ( (rx_line[2] == 'A')&& (rx_line[3] == '?')){    //{    "STA?"
                                    com_ADC_Table_Param_Send();
                                }
                                else if ( (rx_line[2] == 'A')&& (rx_line[3] == 'T')&& (rx_line[4] == '?')){    //{    "STAT?"
                                    com_ADC_Table_Param_Send();
                                }
                                else{
                                    b_CommadERR = 1;
                                }
                                //break;
                        }
                        else if((rx_line[1] == 'M') && (rx_line[2] == 'P')){
                            com_Check_SMP( i_RecCharCount);
                        }
                        else if (rx_line[1] == '?'){    //{    case '?':
                            com_ADC_Table_Param_Send();
                            //break;
                        }
                        else{
                            //default:
                            b_CommadERR = 1;
                            //break;
                        }
                        break;
                    case 'T':  // "T?" Timer Interrupt Counter Repry
                        if (rx_line[1]=='?'){
                                serial.printf("Timer=%d[S}+%d[x0.1mSec] \r\n",timer_1Sec,timer_count); 
//                            sprintf(tx_line,"Timer=%d[S}+%d[x0.1mSec] \r\n",timer_1Sec,timer_count); 
//                            // Copy tx line buffer to large tx buffer for tx interrupt routine
//                            send_line();
 
                        }
                        else if(rx_line[1]=='C'){
                            timer_1Sec = timer_count = 0;
                        }
                        else{
                            b_CommadERR = 1;
                        }
                        break;
                    
                    case 'R':   // RNA / RNB Range Command
                        if(rx_line[1]=='N'){
                            switch(rx_line[2]){
                                case 'A':
                                    b_CommadERR= com_Check_RNA(i_RecCharCount);
                                    break;
                                case 'B':
                                    b_CommadERR= com_Check_RNB(i_RecCharCount);
                                    break;
                                default:
                                    b_CommadERR = 1;
                                    break;
                            }
                        }
 
                        break;  
                    case '?':
                        if(i_RecCharCount == 1){
                            com_ADC_Table_Param_Send();
                              }
                        else{
                                   b_CommadERR = 1;
                        }
                        break;
                      //break;
                    case 'E':
                        if(i_RecCharCount == 1){
                                    i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Stop;
 // 2018.02.19 for 100μsec　Int　Timer Continuas　Enable 
///                                   ADC_Stop();
                           }
                        else{
                                   b_CommadERR = 1;
                        }
                        break;
                    case 'L':
                        if((rx_line[1] == 'E') && (rx_line[2] == 'D') ){
                            b_CommadERR = com_Check_LED(i_RecCharCount);
                        }
                        else{
                        }
                    default:
                        b_CommadERR = 1;
                        break;
                
                }
            }  
            if(b_CommadERR == 0){
                serial.printf("ACK%d \r\n",rx_cr_Rec); 
//                sprintf(tx_line,"ACK%d \r\n",rx_cr_Rec); 
//                // Copy tx line buffer to large tx buffer for tx interrupt routine
//                send_line();
            }
            else{
                serial.printf("ERR%d \r\n",rx_cr_Rec); 
//                sprintf(tx_line,"ERR%d \r\n",rx_cr_Rec); 
//                // Copy tx line buffer to large tx buffer for tx interrupt routine
//                send_line();
            }
            rx_cr_Rec--;
        }
        else{
            rx_cr_Rec = 0;
            break;
        }  
    }
}
//////////////////////////////////////////////////////////////////////////////////
//------------    Command Check & Set Function ---------------------------------//
//  Input :i_RecCharCount :Command Stringth Length                              //
//         rx_line[80] :(Global) Rec Data Stringth                              //
//  Return :bool b_CommadERR  0= ACK                                            //
//                            1= ERR                                            //
//////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------//
//  ADC No.1  "SMP xxxx  ADC Sample Interval Set                              //
//#define ADC_SAMPLE_RATE_MIN  2
//#define ADC_SAMPLE_RATE_MAX  1000
//int st_adc_mode_param.i_sample_interval = 200;  // ADC Sample Rate 5 - 20000(20.0mSec)
//------------------------------------------------------------------------------//
bool com_Check_SMP(int i_RecCharCount)
{
bool b_CommadERR=0;
int i_num=2;
char *pt_comRec;

    if(i_RecCharCount < 4){
        b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        if((i_num >= ADC_SAMPLE_RATE_MIN ) && (i_num <= ADC_SAMPLE_RATE_MAX)){
                 st_adc_mode_param.i_sample_interval = (int)( i_num *10 ) ;
        }
        else{
            b_CommadERR = 1;
        }
        
   }
    return(b_CommadERR);
 }
//------------------------------------------------------------------------------//
// ADC No.2 "RNA 0" CH AMP Range 0 / 1
//------------------------------------------------------------------------------//
bool com_Check_RNA(int i_RecCharCount)
{
bool b_CommadERR=0;
int i_num=0;
char *pt_comRec;

    if(i_RecCharCount < 4){
        b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        if(i_num == 0){
            st_adc_mode_param.i_CH1_Range = i_num;
 //           POut_CH1_Rng = 0;
        }
       else if(i_num == 1){
            st_adc_mode_param.i_CH1_Range = i_num;
 //           POut_CH1_Rng = 1;
        }
         else{
            b_CommadERR = 1;
        }
    }
    return(b_CommadERR);
}
//------------------------------------------------------------------------------//
// ADC No.3 "RNB 0" CH AMP Range 0 / 1
//------------------------------------------------------------------------------//
bool com_Check_RNB(int i_RecCharCount)
{
bool b_CommadERR=0;
int i_num=0;
char *pt_comRec;

    if(i_RecCharCount < 4){
        b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        if(i_num == 0){
            st_adc_mode_param.i_CH2_Range = i_num;
 //           POut_CH2_Rng = 0;
        }
       else if(i_num == 1){
            st_adc_mode_param.i_CH2_Range = i_num;
 //           POut_CH2_Rng = 1;
        }
         else{
            b_CommadERR = 1;
        }
    }
    return(b_CommadERR);
}

//------------------------------------------------------------------------------//
//  ADC No.5  "A?"  DAC Parameter Repry                                          //
//typedef struct  st_adc_param{
//    int   i_sample_interval; // DAC Output Pattern
//    float f_trigger_level;
//    us_trigger_level;
//    int i_pre_trig_point;
//    int i_pulse_end_time;
//}ST_ADC_PARAM;
//
//ST_ADC_PARAM st_adc_mode_param;
//
//------------------------------------------------------------------------------//
void com_ADC_Table_Param_Send()
{
int i_num;
    //2016.06.21 for MBED Dose Measure 2CH_2Range Title & Ver Send Append
        serial.printf("AE-LPC11U35 Small Dose Measure Ver1.00\r\n"); 
//        sprintf(tx_line,"MBED Dose Measure Ver0.45\r\n");   // 2016.06.21 for Max.Min Detect Remove & Title&Software Ver Reply Append
//        send_line();
      
        i_num = ( st_adc_mode_param.i_sample_interval / 10) ;
        serial.printf("SMP %4d[mSec]\r\n",i_num);
//        sprintf(tx_line,"SMP %4d[mSec]\r\n",i_num);
//        send_line();
        i_num = st_adc_mode_param.i_CH1_Range;
        serial.printf("SMP %4d[mSec]\r\n",i_num);
//        sprintf(tx_line,"RNA %1d\r\n",i_num);
//        send_line();
         i_num = st_adc_mode_param.i_CH2_Range;
         serial.printf("RNB %1d\r\n",i_num);
//        sprintf(tx_line,"RNB %1d\r\n",i_num);
//        send_line();
 // for Debug
         serial.printf("ADC Sample Count = %d,BuffLoop=%d\r\n",ADC_Count1,ADC_Count1Block);
//        sprintf(tx_line,"ADC Sample Count = %d,BuffLoop=%d\r\n",ADC_Count1,ADC_Count1Block);
//        send_line();
//
// Ative Mode Status Controll
//#define ActiveMode_ADC_Sample_Stop 0
//#define ActiveMode_ADC_Sample_Busy  1  //
    switch(i_adc_ActiveMode_status){
        case ActiveMode_ADC_Sample_Stop:
            serial.printf( "ADC i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Stop\r\n");
 //           sprintf(tx_line,"ADC i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Stop\r\n");
            break;
        case ActiveMode_ADC_Sample_Busy:
            serial.printf( "ADC i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Busy\r\n");
 //           sprintf(tx_line,"ADC i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Busy\r\n");
            break;
    }
//    send_line();
 
}
//------------------------------------------------------------------------------//
// ADC No.7 "LED 1" Devug LED Active  0 / 1
//------------------------------------------------------------------------------//
bool com_Check_LED(int i_RecCharCount)
{
bool b_CommadERR=0;
int i_num=0;
char *pt_comRec;

    if(i_RecCharCount < 4){
        b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        if(i_num == 0){
            i_LED_Active = Debug_LED_Disable; // Disable
            led1=led2=led3=led4=0;
        }
       else if(i_num == 1){
            i_LED_Active = Debug_LED_Active; // Debug LED Active
            led1=led2=led3=led4=0;
        }
         else{
            b_CommadERR = 1;
        }
    }
    return(b_CommadERR);
}


//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////


//------------------------------------------------------------------------------//
//------------------------------------------------------------------------------//
//-----    Serial tx/rx Communication  
//------------------------------------------------------------------------------//
/*
// Copy tx line buffer to large tx buffer for tx interrupt routine
void send_line() {
    int i;
    char temp_char;
    bool empty;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
 //   NVIC_DisableIRQ(UART1_IRQn);
    empty = (tx_in == tx_out);
    while ((i==0) || (tx_line[i-1] != '\n')) {
// Wait if buffer full
        if (((tx_in + 1) % ser_buffer_size) == tx_out) {
// End Critical Section - need to let interrupt routine empty buffer by sending
//           NVIC_EnableIRQ(UART1_IRQn);
            while (((tx_in + 1) % ser_buffer_size) == tx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
 //           NVIC_DisableIRQ(UART1_IRQn);
        }
        tx_buffer[tx_in] = tx_line[i];
        i++;
        tx_in = (tx_in + 1) % ser_buffer_size;
    }
    if (device.writeable() && (empty)) {
        temp_char = tx_buffer[tx_out];
        tx_out = (tx_out + 1) % ser_buffer_size;
// Send first character to start tx interrupts, if stopped
        device.putc(temp_char);
    }
// End Critical Section
//    NVIC_EnableIRQ(UART1_IRQn);
    return;
}
*/
// Read a line from the large rx buffer from rx interrupt routine
// 2013.08.08 H.Tsunemoto 
// Append Return Chear Number
int read_line(){
//void read_line() {
    int i;
    i = 0;
    // Start Critical Section - don't interrupt while changing global buffer variables
//    NVIC_DisableIRQ(UART1_IRQn);
     while(rx_in != rx_out){
        rx_line[i] = rx_buffer[rx_out];
         rx_out = (rx_out + 1) % ser_buffer_size;
        if((rx_line[i] == '\r') || (rx_line[i] == '\n')){
            break;
       }
             i++;

    }
    rx_line[i] = 0;
// End Critical Section
 //   NVIC_EnableIRQ(UART1_IRQn);
    return(i);
}
//////////////////////////////////////////////////////////
//   Serial Data Input USB=>Buffer                      //
//////////////////////////////////////////////////////////
void Rx_1char() {
   if( i_LED_Active == Debug_LED_Active){
       led1=1;
    }
    //if data is exist
    if (serial.available()) {
        /////////////////////////////////////////////////////////////////////
       rx_buffer[rx_in] = serial._getc();
//       rx_buffer[rx_in] = device.getc();
        //--------  小文字　＝＞　大文字　変換-------------//
        if((rx_buffer[rx_in] >= 'a') && (rx_buffer[rx_in] <= 'z')){
            rx_buffer[rx_in] &= 0x0DF;  // 'a'0x62 => 'A'0x42
            //            rx_buffer[rx_in] -= 0x20;  // 'a'0x62 => 'A'0x42
        }
        // -- Char CR Rec Counter ----//
        if((rx_buffer[rx_in]== '\r') || (rx_buffer[rx_in]== '\n')){
            rx_cr_Rec ++;
        }
        rx_in = (rx_in + 1) % ser_buffer_size;
    }
    if( i_LED_Active == Debug_LED_Active){
         led1=0;
    }

            /////////////////////////////////////////////////////////////////////
}


//----------------------------------------------------------------------------------//
