/////////////////////////////////////////////////////////////////////
//  MBED  Pulse Test OutPut / Input Checkfor RIX/TRIX              //
//      copy from SingleCH Dose Measure                            //
///            Since 2018.05.08  H.Tsunemoto                       //
//          Pulse Output X-ray Off P30 
/////////////////////////////////////////////////////////////////////

#include "mbed.h"
#include "stdio.h"
#include "math.h"
#include "LPC17xx.h" 
// Serial TX & RX interrupt loopback test using formatted IO - sprintf and sscanf
// Connect TX to RX (p9 to p10)
// or can also use USB and type back in the number printed out in a terminal window
// Sends out ASCII numbers in a loop and reads them back
// Since 2013.08.
// If not the same number LED4 goes on
// LED1 and LED2 ADC
// LED3 changing indicate main loop running

//-------------------------------------//
// --- MBED I/O Asign  declaration --- //
//-------------------------------------//
// Serial Port Asign P9:TX P10:RX
Serial device(USBTX, USBRX); // tx, rx  //Serial device(p9, p10);  // tx, rx
// ADC Port Asign P15: ad_ch1  P16 = ad_ch2
// 2017.02.08 H.Tsunemoto 
AnalogIn ad_ch1(p20); // AD CH1 P19 MBED ADC Input
AnalogIn ad_ch2(p19); // AD CH2 P20 MBED ADC Input
//AnalogIn ad_ch3(p17); //AD CH2
AnalogOut dac_output(p18);
//DigitalOut POut_CH1_Rng(p21);   // Pout CH1 Range Select
//DigitalOut POut_CH2_Rng(p22);   // Pout CH2 Range Select
DigitalOut POut_P30_Pulse(p30);   // Pout CH2 Range Select
DigitalOut POut_P29_Pulse(p29);   // Pout CH2 Range Select
DigitalIn  PInp_P21_Port(p21);      // Port I/O Status Input

// Can also use USB and type back in the number printed out in a terminal window
// Serial monitor_device(USBTX, USBRX);
DigitalOut led1(LED1);          // ADC Active
DigitalOut led2(LED2);          // ADC Input Cycle
DigitalOut led3(LED3);          // Main Loop Cycle
DigitalOut led4(LED4);          // DAC Active
BusOut leds(LED4,LED3,LED2,LED1); //LED

#define Debug_LED_Active 1
#define Debug_LED_Disable 0
int i_LED_Active = Debug_LED_Disable;
//----  ADC Interrupt Timer -----//
int main_loop_count = 0;
Ticker ADC_Timer;
Timer t;

//-------- ADC Measure Mode Parameter declaration  --------//
typedef struct  st_PulseW_param{
    int   i_sample_interval; // DAC Output Pattern
    int  i_usec_Pulse_width;
    int  i_usec_Pulse_Interval;
    int  i_usec_Pulse_RepCnt;
   int  i_msec_Pulse_width;
    int  i_msec_Pulse_Interval;
    int  i_msec_Pulse_RepCnt;
    int   i_PulseTestEnable;
    int   i_msec_Pulse_OnOffWait;
    int   i_CH2_Range;
 }ST_PulseW_PARAM;

ST_PulseW_PARAM st_p_test_mode_param;

//-------- ADC Measure Mode Parameter Default Set  --------//
const ST_PulseW_PARAM const_PulseTest_Param_Default=
{
        1000       //i_sample_int=1000 microS
        ,5       // Pulse Width  Default 1usec
        ,500       // Pulse Interval Default 100usec
        ,100        // Pulse Repeat Count
        ,10         // i_msec_Pulse_width  Default 1msec
        ,1000        // i_msec_Pulse_width Default 100msec
        ,100         // i_msec_Pulse_RepCnt
        ,0          // Pulse Trase Log Enable Default Disable
        ,50000        // i_msec_Pulse_OnOffWait Default 5000msec
        ,0
 };
void adc_param_init();




//--------------------------------//
// --- Serial Communication  ---  //
//--------------------------------//
void Tx_interrupt();
void Rx_interrupt();
void send_line();
int read_line();  // Return Rec CHAR Count 2013.08.08 Tsunemoto Append



//---------- H.Tsunemoto Scince 2013.08.08  ---------// 
//-----------------------------------------------------------//
//--------- Timer Innterrupt For DAC Control  ---------------//
//-----------------------------------------------------------//
int timer_count=0;
int timer_1Sec=0;

bool b_PulseTestStatus = false;         // Pulse Test STatus
#define P_TESTMode_Nop          0
#define P_TESTMode_1SHOT_OFF    1
#define P_TESTMode_1SHOT_ON     2
#define P_TESTMode_Ntimes_OFF   3
#define P_TESTMode_Ntimes_ON    4
#define P_TESTMode_Ntimes_ONOFF   5

unsigned int ui_PulseTestMode = P_TESTMode_Nop;         // Pulse Test Mode

#define P_TESTSEQ_Nop           0       // Test Start
#define P_TESTSEQ_START         1       // Test Start
#define P_TESTSEQ_ON            2       // Test ON   ONOFFCHeck P29 ON
#define P_TESTSEQ_OFF           3       // Test OFF  ONOFFCHeck P29 OFF
#define P_TESTSEQ_End           4       // Test END
#define P_TESTSEQ_ONOFF_P30_ON  5       // Test ONOFFCHeck P30 ON
#define P_TESTSEQ_ONOFF_P30_OFF 6       // Test ONOFFCHeck P30 OFF

unsigned int ui_PulseTestSequence = P_TESTSEQ_Nop;         // Sequence Status

unsigned int ui_Pulse_ON_Cnt = 0;
unsigned int ui_Pulse_Interval_Cnt = 0;
unsigned int ui_Pulse_Test_Cycle_Cnt = 0;
unsigned int ui_TestTimeCount =0;
unsigned int ui_PulseAfter_Count =0;
int i_PortP21_Stat =1;
int i_PortP21_Stat_New =0;
int i_PortP21_Stat_Ave[3] ={0,0,0};


unsigned int ui_Main_Serial_Delay = 0;
#define MAIN_TEST_STAT_NOP 0
#define MAIN_TEST_STAT_START 1
#define MAIN_TEST_STAT_END  2
#define MAIN_TEST_STAT_CNT  3
unsigned int ui_Main_Test_Status = MAIN_TEST_STAT_NOP;
char c_TEST_msg[32];


//void TIMER0_IRQHandler(void);
void timer0_init(void);
//---------  New Append Function  ---------//

void Ser_Command_Input();
//////////////////////////////////////////////////////////////////////////////////
//------------    Command Check & Set Function ---------------------------------//
//------------  usec Short Pulse Test ---------------//
void  com_Check_usecPulseA(int i_RecCharCount);
void  com_Check_usecPulseUP1(int i_RecCharCount);
void  com_Check_usecPulseUPN(int i_RecCharCount);
void  com_Check_usecPulseB(int i_RecCharCount);
void  com_Check_usecPulseUX1(int i_RecCharCount);
void  com_Check_usecPulseUXN(int i_RecCharCount);
void  com_Check_usecUPW(int i_RecCharCount);
void  com_Check_usecUPI(int i_RecCharCount);
void  com_Check_usecUPC(int i_RecCharCount);
//------------  ｍsec  Pulse Test （Normal)---------------//
//bool com_Check_msecPulseA(int i_RecCharCount);
void  com_Check_msecPulseMP1(int i_RecCharCount);
void com_Check_msecPulseMPN(int i_RecCharCount);
//bool com_Check_msecPulseB(int i_RecCharCount);
void  com_Check_msecPulseMX1(int i_RecCharCount);
void  com_Check_msecPulseMXN(int i_RecCharCount);
void  com_Check_msecPulseMTN(int i_RecCharCount);
void  com_Check_msecPulseMTW(int i_RecCharCount);
void  com_Check_msecMPW(int i_RecCharCount);
void  com_Check_msecMPI(int i_RecCharCount);
void  com_Check_msecMPC(int i_RecCharCount);
void  com_Check_msecMPT(int i_RecCharCount);
//bool com_Check_usecPRC(int i_RecCharCount);
/// ADC No.1 "SMP 1000"  ADC Sample Rate 2 - 1000 msec
bool com_Check_SMP(int i_RecCharCount);
/// ADC No.4 "START" ADC Sample Start
bool com_Check_START(int i_RecCharCount);
// ADC No.5 "STOP" ADC Sample Stop
bool com_Check_STOP(int i_RecCharCount);
// ADC No.6     // "STAT?"
void com_ADC_Table_Param_Send();  
// ADC No.7     // "LED0" LED Ena
bool com_Check_LED(int i_RecCharCount);  
//----------------------------------------------------------------//

// Circular buffers for serial TX and RX data - used by interrupt routines
const int ser_buffer_size = 255;
// might need to increase buffer size for high baud rates
char tx_buffer[ser_buffer_size];
char rx_buffer[ser_buffer_size];
// Circular buffer pointers
// volatile makes read-modify-write atomic
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
// Line buffers for sprintf and sscanf
char tx_line[80];
char rx_line[80];
//---  2013.08.08 Tsunemoto ------//
//--  rx Data Cr Rec Counter
volatile int rx_cr_Rec = 0;
//

/////////////////////////////////////////////////////////////////
//              <<<<  Main Function  >>>>                      //
/////////////////////////////////////////////////////////////////
// ---------------------------------------------------------------// 
// main test program
int main() {
    // Serial Speed Set 
    device.baud(115200);

// Setup a serial interrupt function to receive data
    device.attach(&Rx_interrupt, Serial::RxIrq);
// Setup a serial interrupt function to transmit data
    device.attach(&Tx_interrupt, Serial::TxIrq);
           POut_P30_Pulse.write(0);
           POut_P29_Pulse.write(0);
 
// Formatted IO test using send and receive serial interrupts
// Timer 0 Interrupt Initial Set //    
    timer0_init();
    timer_count = 0;

//--- ADC Measurement Control Parameter Initial Set ---//
    adc_param_init(); 
    // PInp_P21 Port Status Initial Set
    while (i_PortP21_Stat != i_PortP21_Stat_New)
    {
        
        i_PortP21_Stat_Ave[0] = i_PortP21_Stat_Ave[1];
        i_PortP21_Stat_Ave[1] = i_PortP21_Stat_Ave[2];
        i_PortP21_Stat_Ave[2] = PInp_P21_Port.read();
        if((i_PortP21_Stat_Ave[0] == i_PortP21_Stat_Ave[1])
            && (i_PortP21_Stat_Ave[0] == i_PortP21_Stat_Ave[2])){
             i_PortP21_Stat_New =    i_PortP21_Stat_Ave[0];
             i_PortP21_Stat = i_PortP21_Stat_New;
        }
        
    }
//--- DAC Control Parameter Init --- //
 //   dac1_param_init();
// -- Main Loop -- //
    while (1) {
            if(i_LED_Active == Debug_LED_Active){
                 led3 = (led3+1) & 1;
            }
            if(st_p_test_mode_param.i_PulseTestEnable >0){
                led4 =1;
                i_PortP21_Stat_Ave[0] = i_PortP21_Stat_Ave[1];
                i_PortP21_Stat_Ave[1] = i_PortP21_Stat_Ave[2];
                i_PortP21_Stat_Ave[2] = PInp_P21_Port.read();
                if((i_PortP21_Stat_Ave[0] == i_PortP21_Stat_Ave[1])
                    && (i_PortP21_Stat_Ave[0] == i_PortP21_Stat_Ave[2])){
                    i_PortP21_Stat_New =    i_PortP21_Stat_Ave[0];
               }
                if((ui_Main_Serial_Delay == 0) && (tx_in == tx_out)){
                    if(i_PortP21_Stat != i_PortP21_Stat_New){
                        i_PortP21_Stat = i_PortP21_Stat_New;
//                      i_num = ( st_p_test_mode_param.st_p_test_mode_param.i_PulseTestEnable ) ;
                      sprintf(tx_line,"C:,%4d,P:,%4d,P21=,%1d\r\n"
                      ,ui_TestTimeCount,ui_PulseAfter_Count,i_PortP21_Stat);
                      send_line();
                      ui_Main_Serial_Delay=10;          // Send Check 1.0msec Delay
                    }
                    if(ui_Main_Test_Status != MAIN_TEST_STAT_NOP){
                        ui_Main_Test_Status = MAIN_TEST_STAT_NOP;
                        if(c_TEST_msg[0] >0){
                            sprintf(tx_line,"%s\r\n",c_TEST_msg);
                            send_line();
 //                             c_TEST_msg[0]=0;
                        }
                      ui_Main_Serial_Delay=10;          // Send Check 1.0msec Delay
                    }
                }
                led4 =0;
            }
  //          if (i_adc_ActiveMode_status != ActiveMode_ADC_Sample_Stop){
            
  //              ad_sample_send();// --- ADC Sample & Serial Data Out  ---  //
  //          }
            if(rx_cr_Rec != 0){
                Ser_Command_Input();
            }
 /*            main_loop_count++;
             if(main_loop_count>=100000){
                led3 = (led3+1) & 1;
                main_loop_count = 0;
             }
*/            /////////////////////////////////
      }
}


//-------------------------------------------------------//
//    ADC Measurement Parameter Initial Set                          //
// 2013.08.14 H.Tsunemoto
//typedef struct  st_PulseW_param{
//    int   i_sample_interval; // DAC Output Pattern
//    float f_trigger_level;
//    unsigned short us_trigger_level;    // (3.3f/1023) * f_trigger_level (Image)
//    int i_pre_trig_point;
//    int i_usec_Pulse_end_time;
//}ST_PulseW_PARAM;
//
//ST_PulseW_PARAM st_p_test_mode_param;
//-------------------------------------------------------//
void adc_param_init()
{
    st_p_test_mode_param.i_sample_interval = const_PulseTest_Param_Default.i_sample_interval;

   st_p_test_mode_param.i_usec_Pulse_width = const_PulseTest_Param_Default.i_usec_Pulse_width;
   st_p_test_mode_param.i_usec_Pulse_Interval = const_PulseTest_Param_Default.i_usec_Pulse_Interval;
   st_p_test_mode_param.i_usec_Pulse_RepCnt = const_PulseTest_Param_Default.i_usec_Pulse_RepCnt;

   st_p_test_mode_param.i_msec_Pulse_width = const_PulseTest_Param_Default.i_msec_Pulse_width;
   st_p_test_mode_param.i_msec_Pulse_Interval = const_PulseTest_Param_Default.i_msec_Pulse_Interval;
   st_p_test_mode_param.i_msec_Pulse_RepCnt = const_PulseTest_Param_Default.i_msec_Pulse_RepCnt;
   st_p_test_mode_param.i_msec_Pulse_OnOffWait = const_PulseTest_Param_Default.i_msec_Pulse_OnOffWait;
   st_p_test_mode_param.i_PulseTestEnable = const_PulseTest_Param_Default.i_PulseTestEnable;
  
   /*
     int   i_sample_interval; // DAC Output Pattern
    int  i_usec_Pulse_width;
    int  i_usec_Pulse_Interval;
    int  i_usec_Pulse_RepCnt;
    int  i_msec_Pulse_width;
    int  i_msec_Pulse_Interval;
    int  i_msec_Pulse_RepCnt;
    int   i_PulseTestEnable;
    int   i_msec_Pulse_OnOffWait;
    int   i_CH2_Range;
 
   */
}
///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
// --- 0.1msec Interrupt Timer Pulse Test Sequence --- //
//  #define P_TESTMode_OFF          0
//  #define P_TESTMode_1SHOT_OFF    1
//  #define P_TESTMode_1SHOT_ON     2
//  #define P_TESTMode_Ntimes_OFF   3
//  #define P_TESTMode_Ntimes_ON    4
//  unsigned int ui_PulseTestMode = P_TESTMode_OFF;         // Pulse Test Mode
//  
//  #define P_TESTSEQ_Nop       0       // Test Start
//  #define P_TESTSEQ_START     1       // Test Start
//  #define P_TESTSEQ_ON        2       // Test Start
//  #define P_TESTSEQ_OFF       3       // Test Start
//  #define P_TESTSEQ_End       4       // Test Start
//  unsigned int ui_PulseTestSequence = P_TESTSEQ_Nop;         // Sequence Status
//  unsigned int ui_Pulse_ON_Cnt = 0;
//  unsigned int ui_Pulse_Interval_Cnt = 0;
//  unsigned int ui_Pulse_Test_Cycle_Cnt = 0;
/////////////////////////////////////////////////////////
void PulseTestSequence(void)
{
        /////////////////////////////////////////////////////////
        //////////    -------------------------    //////////////   
        //////////       Pulse Test Sequence       //////////////   
        //////////    -------------------------    //////////////
        /////////////////////////////////////////////////////////
        switch (ui_PulseTestMode){
            case P_TESTMode_Nop:
                break;
        /////////////////////////////////////////////////////////
        //////////     --------------------------   //////////////
        //////////     --   XRay OFF 1Shot     --   //////////////
        //////////     --------------------------   //////////////
        /////////////////////////////////////////////////////////
            case P_TESTMode_1SHOT_OFF:
                //  -----------    X ray OFF 1Shot Test  ----------//
                switch (ui_PulseTestSequence){
                    case P_TESTSEQ_Nop:
                        break;
                    case P_TESTSEQ_START:
//                         sprintf(c_TEST_msg,"START,P30,P1Shot\n");
//                        ui_Main_Test_Status = MAIN_TEST_STAT_START;
                       POut_P30_Pulse.write(1);
 //                       i_PortP21_Stat = PInp_P21_Port.read();
                        ui_PulseAfter_Count =0;
                        ui_TestTimeCount=1;
                        ui_PulseTestSequence = P_TESTSEQ_ON;
                        ui_Pulse_ON_Cnt = st_p_test_mode_param.i_msec_Pulse_width;
                        break;
                    case P_TESTSEQ_ON:
                            if(ui_Pulse_ON_Cnt >0){
                                ui_Pulse_ON_Cnt--;
                            }
                            else{
                                POut_P30_Pulse.write(0);
                                ui_PulseTestSequence = P_TESTSEQ_End;
                                sprintf(c_TEST_msg,"END,P30,P1Shot\n");
                                ui_Main_Test_Status = MAIN_TEST_STAT_END;
                            }
                        break;
                    case P_TESTSEQ_End:
                        break;
                    default:
                        break;
                }
                //--------------------------------------------------//
                break;
        /////////////////////////////////////////////////////////
        //////////     --------------------------   //////////////
        //////////     --   XRay ON(P29) 1Shot --   //////////////
        //////////     --------------------------   //////////////
        /////////////////////////////////////////////////////////
            case P_TESTMode_1SHOT_ON:
               //  -----------    X ray OFF 1Shot Test  ----------//
                switch (ui_PulseTestSequence){
                    case P_TESTSEQ_Nop:
                        break;
                    case P_TESTSEQ_START:
//                        sprintf(c_TEST_msg,"START,P29,P1Shot\n");
//                         ui_Main_Test_Status = MAIN_TEST_STAT_START;
                        POut_P29_Pulse.write(1);
//                        i_PortP21_Stat = PInp_P21_Port.read();
                         ui_PulseAfter_Count =0;
                         ui_TestTimeCount++;
 
                        ui_PulseTestSequence = P_TESTSEQ_ON;
                        ui_Pulse_ON_Cnt = st_p_test_mode_param.i_msec_Pulse_width;
                        break;
                    case P_TESTSEQ_ON:
                            if(ui_Pulse_ON_Cnt >0){
                                ui_Pulse_ON_Cnt--;
                            }
                            else{
                                POut_P29_Pulse.write(0);
                               ui_PulseTestSequence = P_TESTSEQ_End;
                                 sprintf(c_TEST_msg,"END,P29,P1Shot\n");
                                ui_Main_Test_Status = MAIN_TEST_STAT_END;
                           }
                        break;
                    case P_TESTSEQ_End:
                        break;
                    default:
                        break;
                }
                //--------------------------------------------------//
                 break;
        /////////////////////////////////////////////////////////
        //////////     --------------------------------------   //////////////
        //////////     --   XRay OFF(P30) N Times Test     --   //////////////
        //////////     --------------------------------------   //////////////
        /////////////////////////////////////////////////////////
           case P_TESTMode_Ntimes_OFF:
               //  -----------    X ray OFF Cycle N Test  ----------//
                switch (ui_PulseTestSequence){
                    case P_TESTSEQ_Nop:
                        break;
                    case P_TESTSEQ_START:
//                       sprintf(c_TEST_msg,"START,P30,PN:,%4d,Times\n",st_p_test_mode_param.i_msec_Pulse_RepCnt);
//                        ui_Main_Test_Status = MAIN_TEST_STAT_START;
                           ui_TestTimeCount=1;
                           sprintf(c_TEST_msg,"TEST_N,%4d,OFF\n",ui_TestTimeCount);
                            ui_Main_Test_Status = MAIN_TEST_STAT_CNT;
                       POut_P30_Pulse.write(1);
 //                       i_PortP21_Stat = PInp_P21_Port.read();
                        ui_PulseAfter_Count =0;
                        ui_PulseTestSequence = P_TESTSEQ_ON;
                        ui_Pulse_ON_Cnt = st_p_test_mode_param.i_msec_Pulse_width;
                      if(st_p_test_mode_param.i_msec_Pulse_RepCnt > 0){
                            ui_Pulse_Test_Cycle_Cnt = st_p_test_mode_param.i_msec_Pulse_RepCnt-1;
                        }
                        else{
                            ui_Pulse_Test_Cycle_Cnt = 0;
                        }
                       break;
                    case P_TESTSEQ_ON:
                            if(ui_Pulse_ON_Cnt >0){
                                ui_Pulse_ON_Cnt--;
                            }
                            else{
                                POut_P30_Pulse.write(0);

                                if(ui_Pulse_Test_Cycle_Cnt >0){
                                    ui_Pulse_Test_Cycle_Cnt--;
                                    ui_Pulse_Interval_Cnt = st_p_test_mode_param.i_msec_Pulse_Interval;
                                    ui_PulseTestSequence = P_TESTSEQ_OFF;
                                }
                                else{
                                    ui_PulseTestSequence = P_TESTSEQ_End;
                                    sprintf(c_TEST_msg,"END,P30,PN:\n");
                                    ui_Main_Test_Status = MAIN_TEST_STAT_END;
                                }
                            }
                        break;
                    case P_TESTSEQ_OFF:
                            if(ui_Pulse_Interval_Cnt >0){
                                ui_Pulse_Interval_Cnt--;
                            }
                            else{
                                 ui_TestTimeCount++;
                                sprintf(c_TEST_msg,"TEST_N,%4d,OFF\n",ui_TestTimeCount);
                                ui_Main_Test_Status = MAIN_TEST_STAT_CNT;
                                POut_P30_Pulse.write(1);
 //                               i_PortP21_Stat = PInp_P21_Port.read();
                                ui_PulseAfter_Count =0;
                               ui_Pulse_ON_Cnt = st_p_test_mode_param.i_msec_Pulse_width;
                                 ui_PulseTestSequence = P_TESTSEQ_ON;
                            }
                        break;
                    case P_TESTSEQ_End:
                        break;
                    default:
                        break;
                }
                //--------------------------------------------------//
                break;
        /////////////////////////////////////////////////////////
        //////////     --------------------------------------   //////////////
        //////////     --   XRay ON(P29) N Times Test     --   //////////////
        //////////     --------------------------------------   //////////////
        /////////////////////////////////////////////////////////
          case P_TESTMode_Ntimes_ON:
              //  -----------    X ray OFF Cycle N Test  ----------//
                switch (ui_PulseTestSequence){
                    case P_TESTSEQ_Nop:
                        break;
                    case P_TESTSEQ_START:
                                   ui_TestTimeCount=1;
                           sprintf(c_TEST_msg,"TEST_N,%4d,ON\n",ui_TestTimeCount);
                            ui_Main_Test_Status = MAIN_TEST_STAT_CNT;
 //                       sprintf(c_TEST_msg,"START,P29,PN:,%4d,Times\n",st_p_test_mode_param.i_msec_Pulse_RepCnt);
 //                       ui_Main_Test_Status = MAIN_TEST_STAT_START;
                          POut_P29_Pulse.write(1);
//                        i_PortP21_Stat = PInp_P21_Port.read();
                       ui_PulseAfter_Count =0;
                        ui_PulseTestSequence = P_TESTSEQ_ON;
                        ui_Pulse_ON_Cnt = st_p_test_mode_param.i_msec_Pulse_width;
                      if(st_p_test_mode_param.i_msec_Pulse_RepCnt > 0){
                            ui_Pulse_Test_Cycle_Cnt = st_p_test_mode_param.i_msec_Pulse_RepCnt-1;
                        }
                        else{
                            ui_Pulse_Test_Cycle_Cnt = 0;
                        }
                       break;
                    case P_TESTSEQ_ON:
                            if(ui_Pulse_ON_Cnt >0){
                                ui_Pulse_ON_Cnt--;
                            }
                            else{
                                POut_P29_Pulse.write(0);
 //                                ui_TestTimeCount++;
                               if(ui_Pulse_Test_Cycle_Cnt >0){
                                    ui_Pulse_Test_Cycle_Cnt--;
                                    ui_Pulse_Interval_Cnt = st_p_test_mode_param.i_msec_Pulse_Interval;
                                    ui_PulseTestSequence = P_TESTSEQ_OFF;
                                }
                                else{
                                    ui_PulseTestSequence = P_TESTSEQ_End;
                                    sprintf(c_TEST_msg,"END,P29,PN:\n");
                                    ui_Main_Test_Status = MAIN_TEST_STAT_END;
                                 }
                            }
                        break;
                    case P_TESTSEQ_OFF:
                            if(ui_Pulse_Interval_Cnt >0){
                                ui_Pulse_Interval_Cnt--;
                            }
                            else{
                                 ui_TestTimeCount++;
                                sprintf(c_TEST_msg,"TEST_N,%4d,ON\n",ui_TestTimeCount);
                                ui_Main_Test_Status = MAIN_TEST_STAT_CNT;
                                POut_P29_Pulse.write(1);
 //                               i_PortP21_Stat = PInp_P21_Port.read();
                                 ui_PulseAfter_Count =0;
                               ui_Pulse_ON_Cnt = st_p_test_mode_param.i_msec_Pulse_width;
                               ui_PulseTestSequence = P_TESTSEQ_ON;
                            }
                        break;
                    case P_TESTSEQ_End:
                        break;
                    default:
                        break;
                }
                //--------------------------------------------------//
               break;
        ////////////////////////////////////////////////////////////////////////////////
        //////////     ------------------------------------------------   //////////////
        //////////     --   XRay ON/OFF (P29 & P30) N Times Test     --   //////////////
        //////////     ------------------------------------------------   //////////////
        ////////////////////////////////////////////////////////////////////////////////
           case P_TESTMode_Ntimes_ONOFF:
              //  -----------    X ray OFF Cycle N Test  ----------//
                switch (ui_PulseTestSequence){
                    case P_TESTSEQ_Nop:
                        break;
                    case P_TESTSEQ_START:
//                        sprintf(c_TEST_msg,"START,ONOFF_P29_30,PN:,%4d,Times\n",st_p_test_mode_param.i_msec_Pulse_RepCnt);
//                        ui_Main_Test_Status = MAIN_TEST_STAT_START;
                          ui_TestTimeCount=1;
                          sprintf(c_TEST_msg,"TEST_N,%4d,ON\n",ui_TestTimeCount);
                           ui_Main_Test_Status = MAIN_TEST_STAT_CNT;
                          POut_P29_Pulse.write(1);
 //                       i_PortP21_Stat = PInp_P21_Port.read();
                        ui_PulseAfter_Count =0;
                        ui_PulseTestSequence = P_TESTSEQ_ON;
                        ui_Pulse_ON_Cnt = st_p_test_mode_param.i_msec_Pulse_width;
                      if(st_p_test_mode_param.i_msec_Pulse_RepCnt > 0){
                            ui_Pulse_Test_Cycle_Cnt = st_p_test_mode_param.i_msec_Pulse_RepCnt-1;
                        }
                        else{
                            ui_Pulse_Test_Cycle_Cnt = 0;
                        }
                       break;
                    case P_TESTSEQ_ON:
                            if(ui_Pulse_ON_Cnt >0){
                                ui_Pulse_ON_Cnt--;
                            }
                            else{
                                POut_P29_Pulse.write(0);
                                 ui_Pulse_Interval_Cnt = st_p_test_mode_param.i_msec_Pulse_Interval;
                                 ui_PulseTestSequence = P_TESTSEQ_OFF;
                             }
                        break;
                    case P_TESTSEQ_OFF:
                            if(ui_Pulse_Interval_Cnt >0){
                                ui_Pulse_Interval_Cnt--;
                            }
                            else{
                                sprintf(c_TEST_msg,"TEST_N,%4d,OFF\n",ui_TestTimeCount);
                                ui_Main_Test_Status = MAIN_TEST_STAT_CNT;
                               POut_P30_Pulse.write(1);
 //                               i_PortP21_Stat = PInp_P21_Port.read();
                                 ui_PulseAfter_Count =0;
                               ui_Pulse_ON_Cnt = st_p_test_mode_param.i_msec_Pulse_width;
                               ui_PulseTestSequence = P_TESTSEQ_ONOFF_P30_ON;
                            }
                        break;
                    case P_TESTSEQ_ONOFF_P30_ON:
                            if(ui_Pulse_ON_Cnt >0){
                                ui_Pulse_ON_Cnt--;
                            }
                            else{
                                POut_P30_Pulse.write(0);
 
 //                                ui_TestTimeCount++;
                               if(ui_Pulse_Test_Cycle_Cnt >0){
                                    ui_Pulse_Test_Cycle_Cnt--;
                                    ui_Pulse_Interval_Cnt = st_p_test_mode_param.i_msec_Pulse_OnOffWait;
                                    ui_PulseTestSequence = P_TESTSEQ_ONOFF_P30_OFF;
                                }
                                else{
                                    ui_PulseTestSequence = P_TESTSEQ_End;
                                    sprintf(c_TEST_msg,"END,ONOFF_P29_30:\n");
                                    ui_Main_Test_Status = MAIN_TEST_STAT_END;
                                }
                            }
                        break;
                    case P_TESTSEQ_ONOFF_P30_OFF:
                            if(ui_Pulse_Interval_Cnt >0){
                                ui_Pulse_Interval_Cnt--;
                            }
                            else{
                                  ui_TestTimeCount++;
                                 sprintf(c_TEST_msg,"TEST_N,%4d,ON\n",ui_TestTimeCount);
                                ui_Main_Test_Status = MAIN_TEST_STAT_CNT;
                                POut_P29_Pulse.write(1);
 //                               i_PortP21_Stat = PInp_P21_Port.read();
                                 ui_PulseAfter_Count =0;
                               ui_Pulse_ON_Cnt = st_p_test_mode_param.i_msec_Pulse_width;
                               ui_PulseTestSequence = P_TESTSEQ_ON;
                            }
                        break;
                    case P_TESTSEQ_End:
                        break;
                    default:
                        break;
                }
                //--------------------------------------------------//
               break;
            default:        //           
                break;
           

        }
}
//------------------------------------------------------------------------------//
//-----    DAC Control Function 
//  H.Tsunemoto Scince 2013.08.09   
//    int i_pattern; // DAC Output Pattern
//    float f_pulse_high;
//    float f_pulse_low;
//    int i_usec_Pulse_width;
//    int i_usec_Pulse_interval;
//    int i_Total_time;    
//
//------------------------------------------------------------------------------//
//
//------------------------------------------------------------------------//
//  Timer Interrupt Routine
//
//------------------------------------------------------------------------//
extern "C" void TIMER0_IRQHandler (void)
{
    if((LPC_TIM0->IR & 0x01) == 0x01)   // if MR0 interrupt, proceed
    {
        if(i_LED_Active == Debug_LED_Active){
            led2 =1;
        }
        LPC_TIM0->IR |= 1 << 0;         // Clear MR0 interrupt flag
        timer_count++;                  //increment timer_count
        if(timer_count >= 10000){
            timer_count = 0;
            timer_1Sec++;
        }
        if(ui_PulseTestMode != P_TESTMode_Nop){
               ui_PulseAfter_Count ++;
            PulseTestSequence();
            if(ui_Main_Serial_Delay>0){
                ui_Main_Serial_Delay--;
            }
        }
        if(i_LED_Active == Debug_LED_Active){
            led2 =0;
        }
    }
}
 
void timer0_init(void)
{
    LPC_SC->PCONP |=1<1;            //timer0 power on
    // 2013.08.09 H.Tsunemoto    100mSec => 0.1mSec Change
    //LPC_TIM0->MR0 = 2398000;        //100 msec
    LPC_TIM0->MR0 = 2398;        //0.1 msec

    LPC_TIM0->MCR = 3;              //interrupt and reset control
                                    //3 = Interrupt & reset timer0 on match
                                    //1 = Interrupt only, no reset of timer0
    NVIC_EnableIRQ(TIMER0_IRQn);    //enable timer0 interrupt
    LPC_TIM0->TCR = 1;              //enable Timer0
 //   pc.printf("Done timer_init\n\r");
}

//------------------------------------------------------------------//
//-----    Serial rx Commmand Input & Parameter Set Function   -----//
//  Tsunemoto Since 2016.05.20                                     //
// ADC No.1 "SMP 1000"  ADC Sample Rate 2 - 1000 msec
// ADC No.2 "RNA 0" ADC CH1 Range  0 / 1
// ADC No.3 "RNB 1" ADC CH2 Range  0 / 1
// ADC No.4 "START" ADC Sample Start
// ADC No.5 "STOP" ADC Sample Stop
// ADC No.6     // "?"

//------------------------------------------------------------------//
void Ser_Command_Input()
{
    int i_RecCharCount;
//    int b_CommadERR = 0;

    while(rx_cr_Rec != 0){
         // Read a line from the large rx buffer from rx interrupt routine
                 
        if(rx_in != rx_out){   
           i_RecCharCount = read_line();
 //          b_CommadERR = 0;
           if(i_RecCharCount != 0){
//////////////////////////////////////////
//            else{
                switch(rx_line[0]){
                    // Header "M"  Pulse Test  Command
                    // ----  msec Pulse Test Command  ----  //
                    case 'm':
                    case 'M':
                        switch(rx_line[1]){
                            // Header "MP"  Pulse Test  Command
                            case 'P':
                            case 'p':
                                if((rx_line[2] == 'W') ){
                                    com_Check_msecMPW( i_RecCharCount);
                                }
                                else if((rx_line[2] == 'I') ){
                                    com_Check_msecMPI( i_RecCharCount);
                                }
                                else if((rx_line[2] == 'C')){
                                    com_Check_msecMPC( i_RecCharCount);
                                }
                                 else if((rx_line[2] == 'T')){
                                    com_Check_msecMPT( i_RecCharCount);
                                }
                               break;
                             // Header "MF"  Pulse Test  Command
                            case 'f':
                            case 'F':
                                if((rx_line[2] == 'N')){
                                    com_Check_msecPulseMPN( i_RecCharCount);
                                }
                                else if((rx_line[2] == '1')){
                                    com_Check_msecPulseMP1( i_RecCharCount);
                                }
                                 break;
                            // Header "MX"  ADC Control Command
                            case 'X':
                            case 'x':
                                if((rx_line[2] == 'N') ){
                                    com_Check_msecPulseMXN( i_RecCharCount);
                                }
                                else if((rx_line[2] == '1') ){
                                    com_Check_msecPulseMX1( i_RecCharCount);
                                }
                                break;
                             // Header "MF"  Pulse Test  Command
                            case 't':
                            case 'T':
                                if((rx_line[2] == 'N')){
                                    com_Check_msecPulseMTN( i_RecCharCount);
                                }
                                else if((rx_line[2] == 'W')){
                                    com_Check_msecPulseMTW( i_RecCharCount);
                                }
                                 break;
                            default:
                                break;
                        }
                        break;
                    // ----  usec Short Pulse Test Command  ----  //
                    case 'u':
                    case 'U':
                        switch(rx_line[1]){
                            case 'P':
                            case 'p':
                                if((rx_line[2] == 'W') ){
                                    com_Check_usecUPW(i_RecCharCount);
                                }
                                else if((rx_line[2] == 'I') ){
                                    com_Check_usecUPI(i_RecCharCount);
                                }
                                else if((rx_line[2] == 'C')){
                                    com_Check_usecUPC(i_RecCharCount);
                                }
                                break;
                            case 'f':
                            case 'F':
                                if((rx_line[2] == 'N')){
                                    com_Check_usecPulseUPN(i_RecCharCount);
                                }
                                else if((rx_line[2] == '1')){
                                    com_Check_usecPulseUP1(i_RecCharCount);
                                }
                                else{ 
                                    com_Check_usecPulseA(i_RecCharCount);
                                }
                                break;
                            // Header "A"  ADC Control Command
                            case 'X':
                            case 'x':
                                if((rx_line[2] == 'N') ){
                                    com_Check_usecPulseUXN( i_RecCharCount);
                                }
                                else if((rx_line[2] == '1') ){
                                    com_Check_usecPulseUX1( i_RecCharCount);
                                }
                                else{
                                    com_Check_usecPulseB(i_RecCharCount);
                                }
                                break;
                            default:
                                break;
                        }
                         break;
                     case 'S':
                        if(i_RecCharCount == 1){
//                                    i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Busy;
//                                    Start_ADC();
                       }
                        else if (rx_line[1] == 'T'){
                            //case 'T':
                                if((rx_line[2] == 'A') && (rx_line[3] == 'R') && (rx_line[4] == 'T')){
 //                                   i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Busy;
 //                                   Start_ADC();
 
                                }
                                else if((rx_line[2] == 'O') && (rx_line[3] == 'P') ){
 //                                   i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Stop;
 //                                   ADC_Stop();
                                }
                                else if ((rx_line[2] == '?')){    //{    "ST?"
                                    com_ADC_Table_Param_Send();
                                }
                                else if ( (rx_line[2] == 'A')&& (rx_line[3] == '?')){    //{    "STA?"
                                    com_ADC_Table_Param_Send();
                                }
                                else if ( (rx_line[2] == 'A')&& (rx_line[3] == 'T')&& (rx_line[4] == '?')){    //{    "STAT?"
                                    com_ADC_Table_Param_Send();
                                }
                                else{
 //                                   b_CommadERR = 1;
                                }
                                //break;
                        }
                        else if((rx_line[1] == 'M') && (rx_line[2] == 'P')){
                            com_Check_SMP( i_RecCharCount);
                        }
                        else if (rx_line[1] == '?'){    //{    case '?':
                            com_ADC_Table_Param_Send();
                            //break;
                        }
                        else{
                            //default:
//                            b_CommadERR = 1;
                            //break;
                        }
                        break;
                    case 'T':  // "T?" Timer Interrupt Counter Repry
                        if (rx_line[1]=='?'){
                            sprintf(tx_line,"Timer=%d[S}+%d[x0.1mSec] \r\n",timer_1Sec,timer_count); 
                            // Copy tx line buffer to large tx buffer for tx interrupt routine
                            send_line();
 
                        }
                        else if(rx_line[1]=='C'){
                            timer_1Sec = timer_count = 0;
                        }
                        else{
 //                           b_CommadERR = 1;
                        }
                        break;
                    
                     case '?':
                        if(i_RecCharCount == 1){
                            com_ADC_Table_Param_Send();
                              }
                        else{
 //                                  b_CommadERR = 1;
                        }
                        break;
                      //break;
                    case 'E':
                        if(i_RecCharCount == 1){
 //                                   i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Stop;
 //                                   ADC_Stop();
                           }
                        else{
 //                                  b_CommadERR = 1;
                        }
                        break;
                    case 'L':
                        if((rx_line[1] == 'E') && (rx_line[2] == 'D') ){
                             com_Check_LED(i_RecCharCount);
                        }
                        else{
                        }
                    default:
//                        b_CommadERR = 1;
                        break;
                
                }
            }
//            if(rx_line[0] >= 0x20){
//                if(b_CommadERR == 0){
//                    sprintf(tx_line,"ACK%d \r\n",rx_cr_Rec); 
//                    // Copy tx line buffer to large tx buffer for tx interrupt routine
//                    send_line();
//                }
//                else{
//                    sprintf(tx_line,"ERR%d \r\n",rx_cr_Rec); 
//                    // Copy tx line buffer to large tx buffer for tx interrupt routine
//                    send_line();
//                }
//            }
            rx_cr_Rec--;
        }
        else{
            rx_cr_Rec = 0;
            break;
        }  
    }
}

//////------------------------------------------------------------------------------/////
//////---------------      usec Short Pulse Test Command       ---------------------/////
//////------------------------------------------------------------------------------/////


//////////////////////////////////////////////////////////////////////////////////
//------------    Command Check & Set Function ---------------------------------//
//  Input :i_RecCharCount :Command Stringth Length                              //
//         rx_line[80] :(Global) Rec Data Stringth                              //
//  Return :bool b_CommadERR  0= ACK                                            //
//                            1= ERR                                            //
//////////////////////////////////////////////////////////////////////////////////
void com_Check_usecPulseA(int i_RecCharCount)
{
//    bool b_CommadERR=0;
  //  int i_num=2;
    int i_count = st_p_test_mode_param.i_sample_interval;
    int i;
        if(i_count == 0){
            POut_P30_Pulse.write(1);
            POut_P30_Pulse.write(0);
        }
        else{
           POut_P30_Pulse.write(0);
            for(i=0;i<i_count;i++){
                POut_P30_Pulse.write(1);
            }
            POut_P30_Pulse.write(0);
        }
//    return(b_CommadERR);
}
void  com_Check_usecPulseUP1(int i_RecCharCount)
{
 //   bool b_CommadERR=0;
 //   int i_num=2;
    int i_count = st_p_test_mode_param.i_usec_Pulse_width;
    int i;
        if(i_count == 0){
            POut_P30_Pulse.write(1);
            POut_P30_Pulse.write(0);
        }
        else{
           POut_P30_Pulse.write(0);
            for(i=0;i<i_count;i++){
                POut_P30_Pulse.write(1);
            }
            POut_P30_Pulse.write(0);
        }
//     return(b_CommadERR);   
}

void com_Check_usecPulseUPN(int i_RecCharCount)
{
 //   bool b_CommadERR=0;
 //   int i_num=2;
    int i_PluseWidth = st_p_test_mode_param.i_usec_Pulse_width;
    int i_usec_PulseInt = st_p_test_mode_param.i_usec_Pulse_Interval;
    int i_count = st_p_test_mode_param.i_usec_Pulse_RepCnt;
    if(i_count<0) {
        i_count = 1;
    }
    /*
       int  i_usec_Pulse_width;
    int  i_usec_Pulse_Interval;
    int  i_usec_Pulse_RepCnt;

    */
    int i,k;
    for (k=0;k< i_count;k++){   
           if(i_PluseWidth == 0){
                POut_P30_Pulse.write(1);
                POut_P30_Pulse.write(0);
            }
            else{
                POut_P30_Pulse.write(0);
                for(i=0;i<i_PluseWidth;i++){
                    POut_P30_Pulse.write(1);
                }
                POut_P30_Pulse.write(0);
            }
            if(i_usec_PulseInt == 0){
                POut_P30_Pulse.write(0);
                POut_P30_Pulse.write(0);
            }
            else{
                POut_P30_Pulse.write(0);
                for(i=0;i<i_usec_PulseInt;i++){
                    POut_P30_Pulse.write(0);
                }
                POut_P30_Pulse.write(0);
            }
           
    }
//   return(b_CommadERR);   
}
void  com_Check_usecPulseB(int i_RecCharCount)
{
 //   bool b_CommadERR=0;
 //   int i_num=2;
    int i_count = st_p_test_mode_param.i_sample_interval;
    int i;
        if(i_count == 0){
            POut_P29_Pulse.write(1);
            POut_P29_Pulse.write(0);
        }
        else{
           POut_P29_Pulse.write(0);
            for(i=0;i<i_count;i++){
            POut_P29_Pulse.write(1);
              }
            POut_P29_Pulse.write(0);
        }
//   return(b_CommadERR);    
}
void com_Check_usecPulseUX1(int i_RecCharCount)
{
 //   bool b_CommadERR=0;
 //   int i_num=2;
    int i_count = st_p_test_mode_param.i_usec_Pulse_width;
    int i;
        if(i_count == 0){
            POut_P29_Pulse.write(1);
            POut_P29_Pulse.write(0);
        }
        else{
           POut_P29_Pulse.write(0);
            for(i=0;i<i_count;i++){
            POut_P29_Pulse.write(1);
              }
            POut_P29_Pulse.write(0);
        }
 //     return(b_CommadERR); 
}
void com_Check_usecPulseUXN(int i_RecCharCount)
{
//    bool b_CommadERR=0;
 //   int i_num=2;
 //   int i_count = st_p_test_mode_param.i_sample_interval;
    int i_PluseWidth = st_p_test_mode_param.i_usec_Pulse_width;
    int i_usec_PulseInt = st_p_test_mode_param.i_usec_Pulse_Interval;
    int i_count = st_p_test_mode_param.i_usec_Pulse_RepCnt;
    if(i_count<0) {
        i_count = 1;
    }
   int i,k;
   for (k=0;k< i_count;k++){   
         if(i_PluseWidth == 0){
            POut_P29_Pulse.write(1);
            POut_P29_Pulse.write(0);
        }
        else{
           POut_P29_Pulse.write(0);
            for(i=0;i<i_PluseWidth;i++){
            POut_P29_Pulse.write(1);
              }
            POut_P29_Pulse.write(0);
        }
        if(i_usec_PulseInt == 0){
            POut_P29_Pulse.write(0);
            POut_P29_Pulse.write(0);
        }
        else{
           POut_P29_Pulse.write(0);
            for(i=0;i<i_usec_PulseInt;i++){
            POut_P29_Pulse.write(0);
              }
            POut_P29_Pulse.write(0);
        }
    }
 //     return(b_CommadERR); 
}

//------------------------------------------------------------------------------//
//  ADC No.02  "PAW xxxx  Pulse WidthCount Set                              //
//#define ADC_SAMPLE_RATE_MIN  2
//#define ADC_SAMPLE_RATE_MAX  1000
//int st_p_test_mode_param.i_sample_interval = 200;  // ADC Sample Rate 5 - 20000(20.0mSec)
//------------------------------------------------------------------------------//
void com_Check_usecUPW(int i_RecCharCount)
{
//bool b_CommadERR=0;
int i_num=2;
char *pt_comRec;

    if(i_RecCharCount < 4){
//        b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        st_p_test_mode_param.i_usec_Pulse_width = (int)( i_num);
         
   }
 //   return(b_CommadERR);
 }
//------------------------------------------------------------------------------//
//  ADC No.03  "PIW xxxx  Pulse Interval Count Set                              //
//#define ADC_SAMPLE_RATE_MIN  2
//#define ADC_SAMPLE_RATE_MAX  1000
//int st_p_test_mode_param.i_sample_interval = 200;  // ADC Sample Rate 5 - 20000(20.0mSec)
//------------------------------------------------------------------------------//
void com_Check_usecUPI(int i_RecCharCount)
{
//bool b_CommadERR=0;
int i_num=2;
char *pt_comRec;

    if(i_RecCharCount < 4){
 //       b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        st_p_test_mode_param.i_usec_Pulse_Interval = (int)( i_num);
         
   }
 //   return(b_CommadERR);
 }
//------------------------------------------------------------------------------//
//  ADC No.04  "PRC xxxx  Pulse Repeat Count Set                              //
//#define ADC_SAMPLE_RATE_MIN  2
//#define ADC_SAMPLE_RATE_MAX  1000
//int st_p_test_mode_param.i_sample_interval = 200;  // ADC Sample Rate 5 - 20000(20.0mSec)
//------------------------------------------------------------------------------//
void com_Check_usecUPC(int i_RecCharCount)
{
//bool b_CommadERR=0;
int i_num=2;
char *pt_comRec;

    if(i_RecCharCount < 4){
 //       b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        st_p_test_mode_param.i_usec_Pulse_RepCnt = (int)( i_num);
         
   }
 //   return(b_CommadERR);
 }
//////------------------------------------------------------------------------------/////
//////---------------      ↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑      ---------------------/////
//////------------------------------------------------------------------------------/////

//////------------------------------------------------------------------------------/////
//////---------------         msec Pulse Test Command          ---------------------/////
//////------------------------------------------------------------------------------/////


//////////////////////////////////////////////////////////////////////////////////
//------------    Command Check & Set Function ---------------------------------//
//  Input :i_RecCharCount :Command Stringth Length                              //
//         rx_line[80] :(Global) Rec Data Stringth                              //
//  Return :bool b_CommadERR  0= ACK                                            //
//                            1= ERR                                            //
//////////////////////////////////////////////////////////////////////////////////
void com_Check_msecPulseMP1(int i_RecCharCount)
{
 //   bool b_CommadERR=0;
 //                        sprintf(c_TEST_msg,"START,P30,P1Shot\n");
 //                       ui_Main_Test_Status = MAIN_TEST_STAT_START;
                            sprintf(tx_line,"START,P30,P1Shot\r\n");
                            send_line();
    ui_PulseTestMode = P_TESTMode_Nop;
    ui_PulseTestSequence = P_TESTSEQ_START;
     ui_PulseTestMode = P_TESTMode_1SHOT_OFF;
//     return(b_CommadERR);   
}

void com_Check_msecPulseMPN(int i_RecCharCount)
{
//    bool b_CommadERR=0;
     sprintf(tx_line,"START_N,%4d,Times,OFF_P30\n",st_p_test_mode_param.i_msec_Pulse_RepCnt);
                           send_line();
 //     ui_Main_Test_Status = MAIN_TEST_STAT_START;
     ui_PulseTestMode = P_TESTMode_Nop;
    ui_PulseTestSequence = P_TESTSEQ_START;
     ui_PulseTestMode = P_TESTMode_Ntimes_OFF;
//   return(b_CommadERR);   
}
void com_Check_msecPulseMX1(int i_RecCharCount)
{
//    bool b_CommadERR=0;
    sprintf(tx_line,"START,P29,P1Shot\r\n");
    send_line();
      ui_PulseTestMode = P_TESTMode_Nop;
    ui_PulseTestSequence = P_TESTSEQ_START;
     ui_PulseTestMode = P_TESTMode_1SHOT_ON;
 //    return(b_CommadERR);   
}
void com_Check_msecPulseMXN(int i_RecCharCount)
{
 //   bool b_CommadERR=0;
      sprintf(tx_line,"START_N,%4d,Times,ON_P29\n",st_p_test_mode_param.i_msec_Pulse_RepCnt);
                           send_line();
     ui_PulseTestMode = P_TESTMode_Nop;
   ui_PulseTestSequence = P_TESTSEQ_START;
    ui_PulseTestMode = P_TESTMode_Ntimes_ON;
  //   return(b_CommadERR);   
}
void com_Check_msecPulseMTN(int i_RecCharCount)
{
 //   bool b_CommadERR=0;
                        sprintf(tx_line,"START,%4d,Times,ONOFF_P29_30\n",st_p_test_mode_param.i_msec_Pulse_RepCnt);
                            send_line();
     ui_PulseTestMode = P_TESTMode_Nop;
    ui_PulseTestSequence = P_TESTSEQ_START;
    ui_PulseTestMode = P_TESTMode_Ntimes_ONOFF;
  //   return(b_CommadERR);   
}

void com_Check_msecPulseMTW(int i_RecCharCount)
{
int i_num=2;
char *pt_comRec;

    if(i_RecCharCount < 4){
 //       b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        st_p_test_mode_param.i_msec_Pulse_OnOffWait = (int)( i_num);
         
   }
//    return(b_CommadERR);
 }
//------------------------------------------------------------------------------//
//  ADC No.02  "PAW xxxx  Pulse WidthCount Set                              //
//#define ADC_SAMPLE_RATE_MIN  2
//#define ADC_SAMPLE_RATE_MAX  1000
//int st_p_test_mode_param.i_sample_interval = 200;  // ADC Sample Rate 5 - 20000(20.0mSec)
//------------------------------------------------------------------------------//
void com_Check_msecMPW(int i_RecCharCount)
{
int i_num=2;
char *pt_comRec;

    if(i_RecCharCount < 4){
 //       b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        st_p_test_mode_param.i_msec_Pulse_width = (int)( i_num);
         
   }
//    return(b_CommadERR);
 }
//------------------------------------------------------------------------------//
//  ADC No.03  "PIW xxxx  Pulse Interval Count Set                              //
//#define ADC_SAMPLE_RATE_MIN  2
//#define ADC_SAMPLE_RATE_MAX  1000
//int st_p_test_mode_param.i_sample_interval = 200;  // ADC Sample Rate 5 - 20000(20.0mSec)
//------------------------------------------------------------------------------//
void com_Check_msecMPI(int i_RecCharCount)
{
//bool b_CommadERR=0;
int i_num=2;
char *pt_comRec;

    if(i_RecCharCount < 4){
 //       b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        st_p_test_mode_param.i_msec_Pulse_Interval = (int)( i_num);
         
   }
 //   return(b_CommadERR);
 }
//------------------------------------------------------------------------------//
//  ADC No.04  "PRC xxxx  Pulse Repeat Count Set                              //
//#define ADC_SAMPLE_RATE_MIN  2
//#define ADC_SAMPLE_RATE_MAX  1000
//int st_p_test_mode_param.i_sample_interval = 200;  // ADC Sample Rate 5 - 20000(20.0mSec)
//------------------------------------------------------------------------------//
void com_Check_msecMPC(int i_RecCharCount)
{
//bool b_CommadERR=0;
int i_num=2;
char *pt_comRec;

    if(i_RecCharCount < 4){
 //       b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        st_p_test_mode_param.i_msec_Pulse_RepCnt = (int)( i_num);
         
   }
 //   return(b_CommadERR);
 }
//------------------------------------------------------------------------------//
//  ADC No.04  "PRC xxxx  Pulse Repeat Count Set                              //
//#define ADC_SAMPLE_RATE_MIN  2
//#define ADC_SAMPLE_RATE_MAX  1000
//int st_p_test_mode_param.i_sample_interval = 200;  // ADC Sample Rate 5 - 20000(20.0mSec)
//------------------------------------------------------------------------------//
void com_Check_msecMPT(int i_RecCharCount)
{
//bool b_CommadERR=0;
int i_num=2;
char *pt_comRec;

    if(i_RecCharCount < 4){
 //       b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        if(i_num >0){
            st_p_test_mode_param.i_PulseTestEnable = 1;
        }
        else{
            st_p_test_mode_param.i_PulseTestEnable = 0;
         }
         
   }
 //   return(b_CommadERR);
 }
//////------------------------------------------------------------------------------/////
//////---------------      ↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑      ---------------------/////
//////------------------------------------------------------------------------------/////

//------------------------------------------------------------------------------//
//  ADC No.1  "SMP xxxx  ADC Sample Interval Set                              //
//#define ADC_SAMPLE_RATE_MIN  2
//#define ADC_SAMPLE_RATE_MAX  1000
//int st_p_test_mode_param.i_sample_interval = 200;  // ADC Sample Rate 5 - 20000(20.0mSec)
//------------------------------------------------------------------------------//
bool com_Check_SMP(int i_RecCharCount)
{
bool b_CommadERR=0;
int i_num=2;
char *pt_comRec;

    if(i_RecCharCount < 4){
        b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        st_p_test_mode_param.i_sample_interval = (int)( i_num);
         
   }
    return(b_CommadERR);
 }
//------------------------------------------------------------------------------//
//  ADC No.5  "A?"  DAC Parameter Repry                                          //
//typedef struct  st_PulseW_param{
//    int   i_sample_interval; // DAC Output Pattern
//    float f_trigger_level;
//    us_trigger_level;
//    int i_pre_trig_point;
//    int i_usec_Pulse_end_time;
//}ST_PulseW_PARAM;
//
//ST_PulseW_PARAM st_p_test_mode_param;
//
//------------------------------------------------------------------------------//
void com_ADC_Table_Param_Send()
{
int i_num;
//bool b_CommadERR=0;

    // 2017.02.22 for Single CH Only CH0 <=> CH1 Exchange
          sprintf(tx_line,"Pulse Out Check  MBED\r\n");   // 2017.02.22 for Single CH Only CH0 P,20,21  CH1= P19,22
   //2016.06.21 for MBED Dose Measure 2CH_2Range Title & Ver Send Append
   //      sprintf(tx_line,"MBED Dose Measure Ver0.45\r\n");   // 2016.06.21 for Max.Min Detect Remove & Title&Software Ver Reply Append
        send_line();
      
 //       i_num = ( st_p_test_mode_param.i_sample_interval ) ;
 //       sprintf(tx_line,"SMP %4d[= x 0.2usec]\r\n",i_num);
 //       send_line();
 //       sprintf(tx_line," \r\n",i_num);
 //       send_line();
         sprintf(tx_line,"msec Pulse Test Command & Parameter \r\n");
        send_line();
        i_num = ( st_p_test_mode_param.i_PulseTestEnable ) ;
        sprintf(tx_line," MPT: %1d[= P21 Reply Check ]\r\n",i_num);
        send_line();
      
        sprintf(tx_line," MF1:P30 MX1:P29 Pulse 1shot PW=MPW x0.1msec PulseOut\r\n");
        send_line();
        sprintf(tx_line," MFN: P30 MXN: P29 Pulse Out Repeat\r\n");
        send_line();
         sprintf(tx_line," MTN: ON/OFF P29&30 Repeat Check \r\n");
        send_line();
        sprintf(tx_line,"  Pulse Width :MPW %4d[= x 0.1msec]\r\n",st_p_test_mode_param.i_msec_Pulse_width);
        send_line();
         sprintf(tx_line,"  Pulse Interval :MPI %4d[= x 0.1msec]\r\n",st_p_test_mode_param.i_msec_Pulse_Interval);
        send_line();
        sprintf(tx_line,"  Pulse Repeat Count :MPC %4d Count \r\n",st_p_test_mode_param.i_msec_Pulse_RepCnt);
        send_line();
        sprintf(tx_line,"  OFF-ONP30-P29Wait :MTW %4d Count \r\n",st_p_test_mode_param.i_msec_Pulse_OnOffWait);
        send_line();

        sprintf(tx_line,"for Debug Test \r\n");
        send_line();
       
       sprintf(tx_line,"usec Short Pulse Test Command & Parameter \r\n");
        send_line();
        sprintf(tx_line," UF1:P30 UX1:P29 Pulse 1shot PW=UPW x0.2usec PulseOut\r\n");
        send_line();
        sprintf(tx_line," UFN: P30 UXN: P29 Pulse Out Repeat n\r\n");
        send_line();
        sprintf(tx_line,"  Pulse Width :UPW %4d[= x 0.2usec]\r\n",st_p_test_mode_param.i_usec_Pulse_width);
        send_line();
         sprintf(tx_line,"  Pulse Interval :UPI %4d[= x 0.2usec]\r\n",st_p_test_mode_param.i_usec_Pulse_Interval);
        send_line();
        sprintf(tx_line,"  Pulse Repeat Count :UPC %4d Count \r\n",st_p_test_mode_param.i_usec_Pulse_RepCnt);
        send_line();
 //  return(b_CommadERR);

 // for Debug
  
}
//------------------------------------------------------------------------------//
// ADC No.7 "LED 1" Devug LED Active  0 / 1
//------------------------------------------------------------------------------//
bool com_Check_LED(int i_RecCharCount)
{
bool b_CommadERR=0;
int i_num=0;
char *pt_comRec;

    if(i_RecCharCount < 4){
        b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[3];
        i_num = atoi(pt_comRec);
        if(i_num == 0){
            i_LED_Active = Debug_LED_Disable; // Disable
            led1=led2=led3=led4=0;
        }
       else if(i_num == 1){
            i_LED_Active = Debug_LED_Active; // Debug LED Active
            led1=led2=led3=led4=0;
        }
         else{
            b_CommadERR = 1;
        }
    }
    return(b_CommadERR);
}


//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////


//------------------------------------------------------------------------------//
//------------------------------------------------------------------------------//
//-----    Serial tx/rx Communication  
//------------------------------------------------------------------------------//
// Copy tx line buffer to large tx buffer for tx interrupt routine
void send_line() {
    int i;
    char temp_char;
    bool empty;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
    empty = (tx_in == tx_out);
    while ((i==0) || (tx_line[i-1] != '\n')) {
// Wait if buffer full
        if (((tx_in + 1) % ser_buffer_size) == tx_out) {
// End Critical Section - need to let interrupt routine empty buffer by sending
            NVIC_EnableIRQ(UART1_IRQn);
            while (((tx_in + 1) % ser_buffer_size) == tx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        tx_buffer[tx_in] = tx_line[i];
        i++;
        tx_in = (tx_in + 1) % ser_buffer_size;
    }
    if (device.writeable() && (empty)) {
        temp_char = tx_buffer[tx_out];
        tx_out = (tx_out + 1) % ser_buffer_size;
// Send first character to start tx interrupts, if stopped
        device.putc(temp_char);
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    return;
}

// Read a line from the large rx buffer from rx interrupt routine
// 2013.08.08 H.Tsunemoto 
// Append Return Chear Number
int read_line(){
//void read_line() {
    int i;
    i = 0;
    // Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
     while(rx_in != rx_out){
        rx_line[i] = rx_buffer[rx_out];
         rx_out = (rx_out + 1) % ser_buffer_size;
        if((rx_line[i] == '\r') || (rx_line[i] == '\n')){
            break;
       }
             i++;

    }
    rx_line[i] = 0;
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    return(i);
}

// Interupt Routine to read in data from serial port
void Rx_interrupt() {
 //   led1=1;
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((device.readable()) || (((rx_in + 1) % ser_buffer_size) == rx_out)) {
        rx_buffer[rx_in] = device.getc();
// Uncomment to Echo to USB serial to watch data flow
//        monitor_device.putc(rx_buffer[rx_in]);
        //--------  2016.05.23 Tsunemoto --------------//
        //--------  小文字　＝＞　大文字　変換-------------//
        if((rx_buffer[rx_in] >= 'a') && (rx_buffer[rx_in] <= 'z')){
            rx_buffer[rx_in] -= 0x20;  // 'a'0x62 => 'A'0x42
        }
        //------- 2013.08.08 Tsunemoto ------------//
        // -- Char CR Rec Counter ----//
        if((rx_buffer[rx_in]== '\r') || (rx_buffer[rx_in]== '\n')){
           //led2 = 1;
           rx_cr_Rec ++;
        }
        //----------------------------//
        rx_in = (rx_in + 1) % ser_buffer_size;
    }
//    led1=0;
    return;
}

// Interupt Routine to write out data to serial port
void Tx_interrupt() {
    //led2=1;
// Loop to fill more than one character in UART's transmit FIFO buffer
// Stop if buffer empty
    while ((device.writeable()) && (tx_in != tx_out)) {
        device.putc(tx_buffer[tx_out]);
        tx_out = (tx_out + 1) % ser_buffer_size;
        if(i_LED_Active == Debug_LED_Active){
                led1 = 1;
                led1 = 0;
        }
    }
    //led2=0;
    return;
}
//----------------------------------------------------------------------------------//
