#include "mbed.h"
#include "WS2812.h"

const int size = 300; //number of LED´s
      int line = 25;  //length of Flash
DigitalOut myled(LED1);
WS2812 strip (p5,size,6,17,9,14); //mbed 4088:  10,24,20,22    see https://developer.mbed.org/users/bridadan/code/WS2812/ 

//Ticker speed;
//Ticker baum; 


int Buffer[size + 70]; //a buffer is never to big
int dir   =  1;
int spe   =  5;
int spe_2 = 70;
int nd    =  1;
int run_i  = 1;

// Short Light   {Startposition,Direktion} Startposition must > 10 and < (size-10)
int single[5][2]={{9,1},{140,1},{280,1},{120,-1},{260,-1}};





int color_set(uint8_t rot,uint8_t gruen, uint8_t blau, uint8_t alpha)
{
  return ((alpha<<24) + (rot<<16) + (gruen<<8) + blau);   
}


//change speed
void do_speed()
{
  spe_2 = spe_2 + dir;
  if (spe_2 > 180) dir = -1;
  if (spe_2 < 60) dir =  1;
  spe = spe_2/20;
}


void do_single(int num,int c)
{
 Buffer[single[num][0]] = color_set(((c&0x00FF0000)>>16)-nd%30,
 ((c&0x0000FF00)>>8)+nd%35,(c&0x000000FF)+nd%10,250);
 double ran = rand()%2;
 single[num][0] = single[num][0] + ((ran)* single[num][1]);
 if (single[num][0] > (size-13))  single[num][1]= -1;
 if (single[num][0] < 8  )  single[num][1] = 1;
 Buffer[single[num][0]-3] = color_set(0,0,0,0);
 Buffer[single[num][0]-4] = color_set(0,0,0,0);
 Buffer[single[num][0]+3] = color_set(0,0,0,0);
 Buffer[single[num][0]+4] = color_set(0,0,0,0);
}


void do_baum()
{  
  for (int i = size - line; i < size; i++)
  {
    Buffer[i] &= color_set(124+spe*12+nd%60,255-spe*27+nd%45,124-spe*13-nd%35,240-nd%200);
    nd+=12;
  }
}

void do_run()
{
  if (run_i < line)
  {
    for (int j = 0; j < spe; j++) Buffer[run_i+j] = color_set(spe*20-nd%15,253-spe*20,124-spe*13+nd%25,240);
  } 
  else
  {
    for (int j = 0; j < spe; j++) Buffer[run_i+j]       = color_set(spe*27-nd%25,253-spe*27,124-spe*13+nd%55,240);
    for (int j = 0; j < spe; j++) Buffer[run_i+j-line]  = color_set(0,0,0,0);
  }
  
  run_i+=spe;
    
  if(run_i > size) run_i = 0;   
}

void show(bool i)
{
  do_single(0,0x00ff0000);
  do_single(1,0x0006de08);
  do_single(2,0x000000df);
  do_single(3,0xdeadbeef);
  do_single(4,0x00442288);
  do_baum();
  do_speed();
  do_run();
  if (i>0) for (int a=0; a<size;a++){ Buffer[a]^= 4294967295;}; 
  strip.write(Buffer);   
}

int main() 
{
  while(1)
  {
    show(0);
    myled = !myled;   
  }  
}
